/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.io.File;
import java.io.IOException;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Label;
import org.zkoss.zul.Progressmeter;
import tools.dynamia.commons.URLable;
import tools.dynamia.io.IOUtils;
import tools.dynamia.io.Resource;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.ImageCache;

public class CoolLabel
extends Div {
    public static final String ON_TITLE_CHANGED = "onTitleChanged";
    private static final long serialVersionUID = 8628833708100482613L;
    private final Label titleLabel;
    private final Label subtitleLabel;
    private final Label descriptionLabel;
    private org.zkoss.zul.Image image;
    private File imageFile;
    private String imageURL;
    private String noImagePath = "/zkau/web/tools/images/no-photo.jpg";
    private org.zkoss.zul.Image noImage;
    private int progress;
    private final Progressmeter progressmeter;
    private boolean showImage = true;
    private boolean breakLinesSubtitle;
    private boolean breakLinesDescription;

    public CoolLabel() {
        this.setSclass("cool-lb");
        this.titleLabel = new Label();
        this.titleLabel.setSclass("cool-lb-title");
        this.titleLabel.setStyle("display: block");
        this.subtitleLabel = new Label();
        this.subtitleLabel.setSclass("cool-lb-subtitle");
        this.subtitleLabel.setStyle("display: block");
        this.descriptionLabel = new Label();
        this.descriptionLabel.setSclass("cool-lb-description");
        this.descriptionLabel.setStyle("display: block");
        this.progressmeter = new Progressmeter();
        this.progressmeter.setSclass("cool-lb-progress");
        this.progressmeter.setWidth("100%");
        this.progressmeter.setHeight("10px");
        this.setNoImagePath(this.noImagePath);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (progress > 100) {
            progress = 100;
        } else if (progress < 0) {
            progress = 0;
        }
        this.progressmeter.setValue(progress);
        this.layout();
    }

    public boolean isShowImage() {
        return this.showImage;
    }

    public void setShowImage(boolean showImage) {
        this.showImage = showImage;
        this.layout();
    }

    public org.zkoss.zul.Image getImage() {
        return this.image;
    }

    public void setImage(org.zkoss.zul.Image image) {
        if (this.image != image) {
            this.image = image;
            if (this.image != null) {
                this.image.setSclass("cool-lb-image");
            }
            this.layout();
        }
    }

    public void setImageFile(File file) {
        this.imageFile = file;
        try {
            if (file != null) {
                this.image = new org.zkoss.zul.Image();
                this.image.setContent((Image)new AImage(file));
                this.setImage(this.image);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
        if (imageURL != null) {
            this.setImage(this.loadImageFromURL(imageURL));
        }
    }

    public void setImageURL(URLable urLable) {
        if (urLable != null) {
            this.setImageURL(urLable.toURL());
        }
    }

    private org.zkoss.zul.Image loadImageFromURL(String imageURL) {
        org.zkoss.zul.Image newimage = new org.zkoss.zul.Image();
        if (imageURL.startsWith("classpath:")) {
            try {
                Resource resource;
                AImage imageContent = ImageCache.get(imageURL);
                if (imageContent == null && (resource = IOUtils.getResource((String)imageURL)).exists()) {
                    imageContent = new AImage(resource.getFilename(), resource.getInputStream());
                    ImageCache.add(imageURL, imageContent);
                }
                if (imageContent != null) {
                    newimage.setContent((Image)imageContent);
                }
            }
            catch (Exception exception) {}
        } else {
            newimage.setSrc(imageURL);
        }
        return newimage;
    }

    public void setTitle(String title) {
        if (title != null && !title.equals(this.titleLabel.getValue())) {
            this.fireOnTitleChanged();
        }
        this.titleLabel.setValue(title);
    }

    public String getTitle() {
        return this.titleLabel.getValue();
    }

    public void setSubtitle(String subtitle) {
        this.subtitleLabel.setValue(subtitle);
    }

    public String getSubtitle() {
        return this.subtitleLabel.getValue();
    }

    public void setDescription(String description) {
        this.descriptionLabel.setValue(description);
    }

    public String getDescription() {
        return this.descriptionLabel.getValue();
    }

    public String getNoImagePath() {
        return this.noImagePath;
    }

    public void setNoImagePath(String noImagePath) {
        this.noImagePath = noImagePath;
        if (noImagePath != null && !noImagePath.isEmpty()) {
            this.noImage = this.loadImageFromURL(noImagePath);
            if (this.noImage != null) {
                this.noImage.setSclass("cool-lb-image");
            }
        }
    }

    public void setParent(Component parent) {
        this.layout();
        super.setParent(parent);
    }

    private void layout() {
        this.getChildren().clear();
        Hlayout hlayout = new Hlayout();
        hlayout.setClass("cool-lb-hl");
        if (this.isShowImage()) {
            if (this.image == null && this.noImage != null) {
                this.noImage.setParent((Component)hlayout);
            }
            if (this.image != null) {
                this.image.setParent((Component)hlayout);
            }
        }
        Div div = new Div();
        div.setSclass("cool-lb-labels");
        this.titleLabel.setParent((Component)div);
        this.subtitleLabel.setParent((Component)div);
        this.descriptionLabel.setParent((Component)div);
        div.setParent((Component)hlayout);
        this.appendChild((Component)hlayout);
        if (this.progress > 0) {
            this.progressmeter.setParent((Component)this);
        }
    }

    private void fireOnTitleChanged() {
        Events.postEvent((Event)new Event(ON_TITLE_CHANGED, (Component)this, (Object)this.getTitle()));
    }

    public boolean isBreakLinesSubtitle() {
        return this.breakLinesSubtitle;
    }

    public void setBreakLinesSubtitle(boolean breakLinesSubtitle) {
        this.breakLinesSubtitle = breakLinesSubtitle;
        if (breakLinesSubtitle) {
            this.subtitleLabel.setStyle("display: block; white-space: pre-line");
        } else {
            this.subtitleLabel.setStyle("display: block");
        }
    }

    public boolean isBreakLinesDescription() {
        return this.breakLinesDescription;
    }

    public void setBreakLinesDescription(boolean breakLinesDescription) {
        this.breakLinesDescription = breakLinesDescription;
        if (breakLinesDescription) {
            this.descriptionLabel.setStyle("display: block; white-space: pre-line");
        } else {
            this.descriptionLabel.setStyle("display: block");
        }
    }

    static {
        BindingComponentIndex.getInstance().put("title", (Class)CoolLabel.class);
        ComponentAliasIndex.getInstance().add(CoolLabel.class);
    }
}

