/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Locale;
import java.util.TimeZone;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Label;
import org.zkoss.zul.Span;
import tools.dynamia.commons.DateRange;

public class DateRangebox
extends Span {
    private DateRange value;
    private final Datebox start;
    private final Datebox end;

    public DateRangebox() {
        this(null);
    }

    public DateRangebox(DateRange value) {
        super.setStyle("display: inline");
        this.value = value;
        this.start = new Datebox();
        this.end = new Datebox();
        this.appendChild((Component)this.start);
        this.appendChild((Component)new Label(" - "));
        this.appendChild((Component)this.end);
        this.start.addEventListener("onChange", this::fireEvent);
        this.end.addEventListener("onChange", this::fireEvent);
        this.setShowTodayLink(true);
    }

    private void fireEvent(Event e) {
        if (this.start.getValue() != null && this.end.getValue() != null) {
            Events.postEvent((String)"onChange", (Component)this, (Object)this.getValue());
        }
    }

    public DateRange getValue() {
        if (this.value == null) {
            this.value = new DateRange();
        }
        this.value.setStartDate(this.start.getValue());
        this.value.setEndDate(this.end.getValue());
        return this.value;
    }

    public void setValue(DateRange value) {
        this.value = value;
        if (value != null) {
            this.start.setValue(value.getStartDate());
            this.end.setValue(value.getEndDate());
        }
    }

    public boolean isButtonVisible() {
        return this.start.isButtonVisible();
    }

    public void setButtonVisible(boolean buttonVisible) {
        this.start.setButtonVisible(buttonVisible);
        this.end.setButtonVisible(buttonVisible);
    }

    public void setFormat(String format) throws WrongValueException {
        this.start.setFormat(format);
        this.end.setFormat(format);
    }

    public String getRealFormat() {
        return this.start.getRealFormat();
    }

    public TimeZone getTimeZone() {
        return this.start.getTimeZone();
    }

    public void setTimeZone(TimeZone tzone) {
        this.start.setTimeZone(tzone);
        this.end.setTimeZone(tzone);
    }

    public void setTimeZone(String id) {
        this.start.setTimeZone(id);
        this.end.setTimeZone(id);
    }

    public boolean isTimeZonesReadonly() {
        return this.start.isTimeZonesReadonly();
    }

    public void setTimeZonesReadonly(boolean readonly) {
        this.start.setTimeZonesReadonly(readonly);
        this.end.setTimeZonesReadonly(readonly);
    }

    public Locale getLocale() {
        return this.start.getLocale();
    }

    public void setLocale(Locale locale) {
        this.start.setLocale(locale);
        this.end.setLocale(locale);
    }

    public void setLocale(String locale) {
        this.start.setLocale(locale);
        this.end.setLocale(locale);
    }

    public void setOpen(boolean open) {
        this.start.setOpen(open);
        this.end.setOpen(open);
    }

    public void setConstraint(String constr) {
        this.start.setConstraint(constr);
        this.end.setConstraint(constr);
    }

    public boolean getShowTodayLink() {
        return this.start.getShowTodayLink();
    }

    public void setShowTodayLink(boolean showTodayLink) {
        this.start.setShowTodayLink(showTodayLink);
        this.end.setShowTodayLink(showTodayLink);
    }

    public String getTodayLinkLabel() {
        return this.start.getTodayLinkLabel();
    }

    public void setTodayLinkLabel(String todayLinkLabel) {
        this.start.setTodayLinkLabel(todayLinkLabel);
        this.end.setTodayLinkLabel(todayLinkLabel);
    }

    public String getPlaceholder() {
        return this.start.getPlaceholder();
    }

    public void setPlaceholder(String placeholder) {
        this.start.setPlaceholder(placeholder);
        this.end.setPlaceholder(placeholder);
    }

    public void setInplace(boolean inplace) {
        this.start.setInplace(inplace);
        this.end.setInplace(inplace);
    }

    public boolean isInplace() {
        return this.start.isInplace();
    }

    public boolean isDisabled() {
        return this.start.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.start.setDisabled(disabled);
        this.end.setDisabled(disabled);
    }

    public Datebox getStart() {
        return this.start;
    }

    public Datebox getEnd() {
        return this.end;
    }
}

