/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.time.Month;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ComboitemRenderer;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Intbox;
import org.zkoss.zul.Vlayout;
import tools.dynamia.commons.ClassMessages;
import tools.dynamia.commons.DateTimeUtils;
import tools.dynamia.web.util.HttpUtils;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.ui.MonthItemRenderer;
import tools.dynamia.zk.util.ZKUtil;

public class DateSelector
extends Div {
    private final ClassMessages messages = ClassMessages.get(DateSelector.class);
    private Combobox daycombo;
    private Combobox monthcombo;
    private Intbox yearbox;
    private Integer selectedDay;
    private Integer selectedMonth;
    private Integer selectedYear;
    private Date selected;

    public DateSelector() {
        this(null);
    }

    public DateSelector(Date selected) {
        this.initUI();
        this.setSelected(selected);
    }

    private void initUI() {
        Hlayout container = new Hlayout();
        if (HttpUtils.isSmartphone()) {
            container = new Vlayout();
        }
        container.setHflex("1");
        this.daycombo = new Combobox();
        this.daycombo.setPlaceholder(this.messages.get("day"));
        this.daycombo.setReadonly(true);
        this.daycombo.addEventListener("onSelect", this::fireListener);
        this.daycombo.setHflex("1");
        List days = IntStream.range(1, 32).boxed().collect(Collectors.toList());
        ZKUtil.fillCombobox(this.daycombo, days);
        container.appendChild((Component)this.daycombo);
        this.monthcombo = new Combobox();
        this.monthcombo.setPlaceholder(this.messages.get("month"));
        this.monthcombo.setReadonly(true);
        this.monthcombo.setItemRenderer((ComboitemRenderer)new MonthItemRenderer(true));
        this.monthcombo.addEventListener("onSelect", this::fireListener);
        this.monthcombo.setHflex("1");
        ZKUtil.fillCombobox(this.monthcombo, Month.values(), true);
        container.appendChild((Component)this.monthcombo);
        this.yearbox = new Intbox();
        this.yearbox.setConstraint("no negative");
        this.yearbox.setPlaceholder(this.messages.get("year"));
        this.yearbox.addEventListener("onChange", this::fireListener);
        this.yearbox.setHflex("1");
        container.appendChild((Component)this.yearbox);
        this.appendChild((Component)container);
    }

    private void loadValues() {
        if (this.selectedDay != null && this.selectedDay > 0 && this.selectedDay <= 31) {
            ((AbstractListModel)this.daycombo.getModel()).addToSelection((Object)this.selectedDay);
        } else {
            this.daycombo.setSelectedItem(null);
        }
        if (this.selectedMonth != null && this.selectedMonth > 0 && this.selectedMonth <= 12) {
            ((AbstractListModel)this.monthcombo.getModel()).addToSelection((Object)Month.of(this.selectedMonth));
        } else {
            this.monthcombo.setSelectedItem(null);
        }
        this.yearbox.setValue(this.selectedYear);
    }

    private void saveValues() {
        if (this.daycombo.getSelectedItem() != null) {
            this.selectedDay = (Integer)this.daycombo.getSelectedItem().getValue();
        }
        if (this.monthcombo.getSelectedItem() != null) {
            this.selectedMonth = (Integer)this.monthcombo.getSelectedItem().getValue();
        }
        this.selectedYear = this.yearbox.getValue();
    }

    private void fireListener(Event evt) {
        Date newSelected;
        this.saveValues();
        if (this.selectedDay != null && this.selectedMonth != null && this.selectedYear != null && !Objects.equals(this.selected, newSelected = DateTimeUtils.createDate((int)this.selectedYear, (int)this.selectedMonth, (int)this.selectedDay))) {
            this.selected = newSelected;
            Events.postEvent((Event)new Event("onSelect", (Component)this, (Object)this.selected));
        }
    }

    public Integer getSelectedDay() {
        return this.selectedDay;
    }

    public void setSelectedDay(Integer selectedDay) {
        this.selectedDay = selectedDay;
    }

    public Integer getSelectedMonth() {
        return this.selectedMonth;
    }

    public void setSelectedMonth(Integer selectedMonth) {
        this.selectedMonth = selectedMonth;
    }

    public Integer getSelectedYear() {
        return this.selectedYear;
    }

    public void setSelectedYear(Integer selectedYear) {
        this.selectedYear = selectedYear;
    }

    public Date getSelected() {
        this.saveValues();
        return this.selected;
    }

    public void setSelected(Date selected) {
        this.selected = selected;
        this.selectedDay = null;
        this.selectedMonth = null;
        this.selectedYear = null;
        if (selected != null) {
            this.selectedDay = DateTimeUtils.getDay((Date)selected);
            this.selectedMonth = DateTimeUtils.getMonth((Date)selected);
            this.selectedYear = DateTimeUtils.getYear((Date)selected);
            this.loadValues();
        }
    }

    public Combobox getDaycombo() {
        return this.daycombo;
    }

    public Combobox getMonthcombo() {
        return this.monthcombo;
    }

    public Intbox getYearbox() {
        return this.yearbox;
    }

    static {
        ComponentAliasIndex.getInstance().add("dateselector", DateSelector.class);
        BindingComponentIndex.getInstance().put("selected", (Class)DateSelector.class);
    }
}

