/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.A;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Span;
import tools.dynamia.zk.ui.Calculator;
import tools.dynamia.zk.ui.CanBeReadonly;
import tools.dynamia.zk.util.ZKUtil;

public class DecimalboxCalculator
extends Span
implements CanBeReadonly {
    private final Decimalbox decimalbox;
    private final Calculator calculator;
    private final A calcButton;
    private final Popup calcPopup;
    private BigDecimal value;

    public DecimalboxCalculator() {
        this.setSclass("decimalbox-calc");
        this.decimalbox = new Decimalbox();
        this.calcButton = new A();
        this.calcButton.setZclass("decimalbox-calc-button");
        this.calcButton.setIconSclass("z-icon-calculator");
        this.calculator = new Calculator();
        this.calculator.setWidth("200px");
        this.calculator.setHeight("300px");
        this.calcPopup = new Popup();
        this.calcPopup.appendChild((Component)this.calculator);
        this.calcPopup.setPage(ZKUtil.getFirstPage());
        this.calcPopup.setStyle("margin: 0; padding: 0px");
        this.calcPopup.setSclass("decimalbox-calc-popup");
        this.appendChild((Component)this.decimalbox);
        this.appendChild((Component)this.calcButton);
        this.calculator.addEventListener("onOK", e -> {
            this.setValue(BigDecimal.valueOf(this.calculator.getResult().doubleValue()));
            Events.postEvent((String)"onChange", (Component)this, (Object)this.value);
        });
        this.calcButton.addEventListener("onClick", e -> {
            this.calculator.setValue("");
            this.calcPopup.open((Component)this.calcButton);
            this.calculator.getDisplayBox().focus();
        });
        this.decimalbox.addEventListener("onChange", e -> {
            this.setValue(this.decimalbox.getValue());
            Events.postEvent((Component)this, (Event)e);
        });
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        if (!Objects.equals(this.value, value)) {
            this.decimalbox.setValue(value);
            this.value = value;
        }
    }

    public double doubleValue() throws WrongValueException {
        return this.decimalbox.doubleValue();
    }

    public int intValue() throws WrongValueException {
        return this.decimalbox.intValue();
    }

    public long longValue() throws WrongValueException {
        return this.decimalbox.longValue();
    }

    public short shortValue() throws WrongValueException {
        return this.decimalbox.shortValue();
    }

    public int getScale() {
        return this.decimalbox.getScale();
    }

    public void setScale(int scale) {
        this.decimalbox.setScale(scale);
    }

    public void setRoundingMode(int mode) {
        this.decimalbox.setRoundingMode(mode);
    }

    public void setRoundingMode(String name) {
        this.decimalbox.setRoundingMode(name);
    }

    public int getRoundingMode() {
        return this.decimalbox.getRoundingMode();
    }

    public Locale getLocale() {
        return this.decimalbox.getLocale();
    }

    public void setLocale(Locale locale) {
        this.decimalbox.setLocale(locale);
    }

    public void setLocale(String locale) {
        this.decimalbox.setLocale(locale);
    }

    public String getFormat() {
        return this.decimalbox.getFormat();
    }

    public void setFormat(String format) throws WrongValueException {
        this.decimalbox.setFormat(format);
    }

    public String getPlaceholder() {
        return this.decimalbox.getPlaceholder();
    }

    public void setPlaceholder(String placeholder) {
        this.decimalbox.setPlaceholder(placeholder);
    }

    public void setInplace(boolean inplace) {
        this.decimalbox.setInplace(inplace);
    }

    public boolean isInplace() {
        return this.decimalbox.isInplace();
    }

    public boolean isDisabled() {
        return this.decimalbox.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.decimalbox.setDisabled(disabled);
        this.calcButton.setVisible(!disabled);
    }

    @Override
    public boolean isReadonly() {
        return this.decimalbox.isReadonly();
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.decimalbox.setReadonly(readonly);
        this.calcButton.setVisible(!readonly);
    }

    public void setConstraint(String constr) {
        this.decimalbox.setConstraint(constr);
    }

    public void setConstraint(Constraint constr) {
        this.decimalbox.setConstraint(constr);
    }

    public Constraint getConstraint() {
        return this.decimalbox.getConstraint();
    }

    public Decimalbox getDecimalbox() {
        return this.decimalbox;
    }

    public Calculator getCalculator() {
        return this.calculator;
    }
}

