/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import org.zkoss.zhtml.I;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Span;
import tools.dynamia.ui.icons.Icon;
import tools.dynamia.ui.icons.IconSize;
import tools.dynamia.ui.icons.IconType;
import tools.dynamia.ui.icons.IconsTheme;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.util.ZKUtil;

public class EnumIconImage
extends Span {
    private static final long serialVersionUID = -5975771607086380537L;
    private IconSize size = IconSize.NORMAL;
    private Enum value;
    private String[] iconsNames;

    public void setValue(Object value) {
        if (value instanceof Enum) {
            this.value = (Enum)value;
            this.render();
        }
    }

    private void render() {
        this.getChildren().clear();
        this.setTooltiptext(null);
        String iconName = this.getIconName();
        if (iconName != null) {
            Icon icon = IconsTheme.get().getIcon(iconName);
            this.setTooltiptext(this.value.name());
            if (icon.getType() == IconType.IMAGE) {
                Image image = new Image();
                image.setParent((Component)this);
                ZKUtil.configureComponentIcon(icon, (Component)image, this.size);
            } else {
                I i = new I();
                i.setParent((Component)this);
                ZKUtil.configureComponentIcon(icon, (Component)i, this.size);
            }
        } else {
            this.appendChild((Component)new Label(this.value.name()));
        }
    }

    private String getIconName() {
        try {
            if (this.value != null) {
                return this.iconsNames[this.value.ordinal()];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public IconSize getSize() {
        return this.size;
    }

    public void setSize(IconSize size) {
        this.size = size;
    }

    public Enum getValue() {
        return this.value;
    }

    public void setSize(String size) {
        this.setSize(IconSize.valueOf((String)size.toUpperCase()));
    }

    public String[] getIconsNames() {
        return this.iconsNames;
    }

    public void setIconsNames(String[] iconsNames) {
        this.iconsNames = iconsNames;
        this.render();
    }

    public void setIconsNames(String iconsNames) {
        if (iconsNames != null) {
            this.setIconsNames(iconsNames.replace(" ", "").split(","));
        }
    }

    static {
        ComponentAliasIndex.getInstance().add(EnumIconImage.class);
        BindingComponentIndex.getInstance().put("value", (Class)EnumIconImage.class);
    }
}

