/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import tools.dynamia.zk.BindingComponentIndex;

public class EnumListbox<T extends Enum>
extends Listbox {
    private static final long serialVersionUID = 3499252837420704166L;
    private Class<? extends Enum> enumClass;
    private List<? extends Enum> enumValues;

    public EnumListbox() {
    }

    public EnumListbox(Class<? extends Enum> enumClass) {
        this.setEnum(enumClass);
    }

    public EnumListbox(Class<? extends Enum> enumClass, List<T> enumValues) {
        this.enumClass = enumClass;
        this.enumValues = enumValues;
        this.buildSelector();
    }

    public final void setEnum(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
        this.buildSelector();
    }

    public final void setEnum(String enumClassName) {
        try {
            this.setEnum(Class.forName(enumClassName));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> getSelected() {
        ArrayList<Enum> selected = new ArrayList<Enum>();
        for (Listitem listitem : this.getSelectedItems()) {
            selected.add((Enum)listitem.getValue());
        }
        return selected;
    }

    public void setSelected(List<T> selected) {
        if (selected != null && this.getItems() != null) {
            for (Listitem listitem : this.getItems()) {
                for (Enum enumValue : selected) {
                    if (listitem.getValue() != enumValue) continue;
                    listitem.setSelected(true);
                }
            }
        }
    }

    private void buildSelector() {
        this.getChildren().clear();
        if (this.enumValues == null || this.enumValues.isEmpty()) {
            this.enumValues = Arrays.asList(this.enumClass.getEnumConstants());
        }
        for (Enum enum_ : this.enumValues) {
            this.appendChild((Component)new Listitem(enum_.toString(), (Object)enum_));
        }
        this.setCheckmark(true);
        this.setMultiple(true);
    }

    static {
        BindingComponentIndex.getInstance().put("selected", (Class)EnumListbox.class);
    }
}

