/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.ext.DynamicPropertied;
import org.zkoss.zul.Div;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.util.ZKUtil;

public class Import
extends Div
implements DynamicPropertied,
AfterCompose,
IdSpace {
    private static final String VALUE = "value";
    private static final long serialVersionUID = -8236823411921386808L;
    private String src;
    private final Map<String, Object> args = new HashMap<String, Object>();
    private boolean valueRequired = false;

    public void afterCompose() {
        this.reload();
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        if (src != null && !src.equals(this.src)) {
            this.src = src;
            this.reload();
            Events.sendEvent((Event)new Event("onChange", (Component)this, (Object)src));
        } else if (src == null) {
            this.src = null;
            this.clear();
        }
    }

    private void clear() {
        this.getChildren().clear();
    }

    public void reload() {
        if (this.valueRequired && this.getValue() == null) {
            return;
        }
        if (this.src != null) {
            this.clear();
            ZKUtil.createComponent(this.src, (Component)this, this.args);
        }
    }

    public void addArg(String name, Object value) {
        this.args.put(name, value);
    }

    public void addArgs(Map<String, Object> args) {
        this.args.putAll(args);
    }

    public Object getArg(String name) {
        return this.args.get(name);
    }

    public void setValue(Object value) {
        this.addArg(VALUE, value);
        this.reload();
    }

    public Object getValue() {
        return this.getArg(VALUE);
    }

    public boolean hasDynamicProperty(String name) {
        return this.args.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this.getArg(name);
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this.addArg(name, value);
    }

    public boolean isValueRequired() {
        return this.valueRequired;
    }

    public void setValueRequired(boolean valueRequired) {
        this.valueRequired = valueRequired;
    }

    static {
        BindingComponentIndex.getInstance().put("src", (Class)Import.class);
        ComponentAliasIndex.getInstance().add(Import.class);
    }
}

