/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Objects;
import org.zkoss.zhtml.I;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;
import org.zkoss.zul.Span;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;

public class Infobox
extends Div {
    private String icon;
    private String text;
    private String number;
    private int progress;
    private boolean showProgress = false;
    private String progressDescription;
    private String background;
    private String iconBackground;
    private final Div uiProgress;
    private final Div uiProgressBar;
    private final Label uiProgressDescription;
    private final Div uiContent;
    private final Span uiIcon;
    private final Label uiText;
    private final Label uiNumber;

    public Infobox() {
        this.setZclass("info-box");
        this.uiIcon = new Span();
        this.uiIcon.setZclass("info-box-icon");
        this.appendChild((Component)this.uiIcon);
        this.uiContent = new Div();
        this.uiContent.setZclass("info-box-content");
        this.appendChild((Component)this.uiContent);
        this.uiText = new Label();
        this.uiText.setZclass("info-box-text");
        this.uiContent.appendChild((Component)this.uiText);
        this.uiNumber = new Label();
        this.uiNumber.setZclass("info-box-number");
        this.uiContent.appendChild((Component)this.uiNumber);
        this.uiProgress = new Div();
        this.uiProgress.setZclass("progress");
        this.uiProgressBar = new Div();
        this.uiProgressBar.setZclass("progress-bar");
        this.uiProgress.appendChild((Component)this.uiProgressBar);
        this.uiProgressDescription = new Label();
    }

    private void updateProgress() {
        if (this.progress > 100) {
            this.progress = 100;
        } else if (this.progress < 0) {
            this.progress = 0;
        }
        this.uiProgressBar.setStyle("width: " + this.progress + "%");
        this.uiProgressDescription.setValue(this.progressDescription);
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        if (showProgress) {
            this.uiContent.appendChild((Component)this.uiProgress);
            this.uiContent.appendChild((Component)this.uiProgressDescription);
        } else {
            this.uiContent.removeChild((Component)this.uiProgress);
            this.uiContent.removeChild((Component)this.uiProgressDescription);
        }
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        if (!Objects.equals(this.icon, icon)) {
            this.icon = icon;
            this.uiIcon.getChildren().clear();
            I i = new I();
            i.setSclass(icon);
            this.uiIcon.appendChild((Component)i);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (!Objects.equals(this.text, text)) {
            this.text = text;
            this.uiText.setValue(text);
        }
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        if (!Objects.equals(this.number, number)) {
            this.number = number;
            this.uiNumber.setValue(number);
            Events.postEvent((Event)new Event("onChange", (Component)this));
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.updateProgress();
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public String getProgressDescription() {
        return this.progressDescription;
    }

    public void setProgressDescription(String progressDescription) {
        this.progressDescription = progressDescription;
        this.updateProgress();
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        if (!Objects.equals(this.background, background)) {
            this.background = background;
            this.setZclass("info-box " + background);
        }
    }

    public String getIconBackground() {
        return this.iconBackground;
    }

    public void setIconBackground(String iconBackground) {
        if (!Objects.equals(this.iconBackground, iconBackground)) {
            this.iconBackground = iconBackground;
            this.uiIcon.setSclass(iconBackground);
        }
    }

    static {
        ComponentAliasIndex.getInstance().put("infobox", Infobox.class);
        BindingComponentIndex.getInstance().put("number", (Class)Infobox.class);
    }
}

