/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Collection;
import java.util.Map;
import org.zkoss.bind.Binder;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Button;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Label;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Window;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.integration.Containers;
import tools.dynamia.viewers.ComponentCustomizer;
import tools.dynamia.viewers.Field;
import tools.dynamia.viewers.FieldCustomizer;
import tools.dynamia.web.util.HttpUtils;
import tools.dynamia.zk.util.ZKBindingUtil;
import tools.dynamia.zk.util.ZKUtil;

public class InputPanel
extends Div {
    public static final String ON_INPUT = "onInput";
    private static final long serialVersionUID = 7388726856898185544L;
    private HtmlBasedComponent textbox;
    private Label label;
    private Button okButton;
    private Object value;
    private final Class inputClass;

    public InputPanel() {
        this(null, null, String.class);
    }

    public InputPanel(Class inputClass) {
        this(null, null, inputClass);
    }

    public InputPanel(Object value, Class inputClass) {
        this(null, value, inputClass);
    }

    public InputPanel(String label, Object value, Class inputClass) {
        this.inputClass = inputClass;
        this.value = value;
        this.renderView(label);
        Binder binder = ZKBindingUtil.createBinder();
        ZKBindingUtil.initBinder(binder, (Component)this, (Object)this);
        ZKBindingUtil.bindComponent(binder, (Component)this.textbox, "inputPanel.value", null);
        ZKBindingUtil.bindBean((Component)this, "inputPanel", (Object)this);
        binder.loadComponent((Component)this, false);
        this.addListeners();
    }

    private void addListeners() {
        this.textbox.addEventListener("onOK", event -> {
            this.saveValue();
            Events.postEvent((String)ON_INPUT, (Component)this, (Object)this.getValue());
        });
        this.okButton.addEventListener("onClick", event -> {
            this.saveValue();
            Events.postEvent((String)ON_INPUT, (Component)this, (Object)this.getValue());
        });
    }

    private void renderView(String label) {
        Vbox box = new Vbox();
        box.setParent((Component)this);
        box.setStyle("margin-bottom: 4px");
        box.setVflex("1");
        box.setHflex("1");
        if (label != null) {
            this.label = new Label();
            this.label.setValue(label);
            this.label.setParent((Component)box);
            this.label.setStyle("font-weight:bold");
        }
        this.textbox = (HtmlBasedComponent)this.buildTextbox();
        this.textbox.setHflex("1");
        this.textbox.setParent((Component)box);
        if (this.textbox instanceof Textbox || this.textbox instanceof Decimalbox || this.textbox instanceof Doublebox) {
            this.textbox.setSclass("form-control");
        }
        this.okButton = new Button("OK");
        this.okButton.setParent((Component)box);
        this.okButton.setIconSclass("z-icon-check");
        this.okButton.setSclass("btn btn-success");
        this.okButton.setStyle("float: right");
    }

    private Component buildTextbox() {
        Class componClass = null;
        Field field = new Field("field", this.inputClass);
        Collection customizers = Containers.get().findObjects(FieldCustomizer.class);
        if (customizers != null) {
            for (FieldCustomizer fieldCustomizer : customizers) {
                fieldCustomizer.customize("form", field);
            }
        }
        componClass = field.getComponentClass() != null ? field.getComponentClass() : Textbox.class;
        Component comp = (Component)BeanUtils.newInstance((Class)componClass);
        if (field.getComponentCustomizer() != null) {
            try {
                ComponentCustomizer customizer = (ComponentCustomizer)BeanUtils.newInstance((String)field.getComponentCustomizer());
                customizer.cutomize(field, (Object)comp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BeanUtils.setupBean((Object)comp, (Map)field.getParams());
        return comp;
    }

    public void setLabel(String label) {
        this.label.setValue(label);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void saveValue() {
    }

    public Object showDialog() {
        Window win = ZKUtil.createWindow(null);
        if (HttpUtils.isSmartphone()) {
            win.setWidth("100%");
        } else {
            win.setWidth("450px");
        }
        win.setClosable(true);
        win.setTitle(this.label.getValue());
        this.label.setValue("");
        this.setParent((Component)win);
        this.addEventListener(ON_INPUT, event -> win.detach());
        try {
            win.doModal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getValue();
    }

    public HtmlBasedComponent getTextbox() {
        return this.textbox;
    }

    public Label getLabel() {
        return this.label;
    }

    public Button getOkButton() {
        return this.okButton;
    }
}

