/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Button;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Label;
import org.zkoss.zul.Row;
import org.zkoss.zul.Rows;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;
import org.zkoss.zul.impl.InputElement;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.util.ZKUtil;

public class Keypad
extends Div {
    public static final Key NEW_ROW;
    private Label displayLabel;
    private InputElement displayBox;
    private boolean autoclearOnOK = true;
    private String labelFormat;
    private String value = "0";
    private Div displayRegion;
    private boolean preferStringValue;
    private List<Key> defaultKeys = new ArrayList<Key>(Arrays.asList(new Key("1"), new Key("2"), new Key("3"), NEW_ROW, new Key("4"), new Key("5"), new Key("6"), NEW_ROW, new Key("7"), new Key("8"), new Key("9"), NEW_ROW, new Key("0"), new Key("00"), new Key("000"), NEW_ROW, new Key("").setLabel("C").setCommand((EventListener<Event>)((EventListener)e -> this.clear())), new Key("").setLabel("backspace").setIcon("fa fa-arrow-left").setCommand((EventListener<Event>)((EventListener)e -> this.backspace())), new Key("").setLabel("OK").setCommand((EventListener<Event>)((EventListener)e -> this.ok()))));
    private boolean disabled;

    public Keypad() {
        this.init();
    }

    public Keypad(Label displayLabel, InputElement displayBox) {
        this.displayLabel = displayLabel;
        this.displayBox = displayBox;
        this.init();
    }

    public Keypad(Label displayLabel) {
        this.displayLabel = displayLabel;
        this.init();
    }

    public Keypad(InputElement displayBox) {
        this.displayBox = displayBox;
        this.init();
    }

    public void init() {
        this.getChildren().clear();
        this.setSclass("keypad");
        this.setStyle("overflow: hidden");
        this.displayRegion = new Div();
        this.displayRegion.setSclass("kp-display");
        this.appendChild((Component)this.displayRegion);
        Grid container = new Grid();
        container.setParent((Component)this);
        container.appendChild((Component)new Rows());
        container.setVflex("1");
        Component row = this.newRow();
        container.getRows().appendChild(row);
        for (Key key : this.defaultKeys) {
            if (key == NEW_ROW) {
                row = this.newRow();
                container.getRows().appendChild(row);
                continue;
            }
            KeyButton btn = new KeyButton(key);
            Cell keycell = new Cell();
            keycell.setHeight("1em");
            keycell.appendChild((Component)btn);
            row.appendChild((Component)keycell);
            keycell.setColspan(key.colSpan);
            keycell.setRowspan(key.rowSpan);
        }
        this.syncDisplay();
    }

    private Component newRow() {
        return new Row();
    }

    public void clear() {
        this.value = "0";
        this.syncDisplay();
    }

    public void backspace() {
        if (!this.value.isEmpty()) {
            this.value = this.value.substring(0, this.value.length() - 1);
            if (this.value.isEmpty()) {
                this.clear();
            } else {
                this.syncDisplay();
            }
        }
    }

    public void ok() {
        Object finalValue;
        if ((this.value == null || this.value.isBlank()) && this.displayBox != null && this.displayBox.getRawValue() != null) {
            this.value = String.valueOf(this.displayBox.getRawValue());
        }
        this.syncDisplay();
        Object object = finalValue = this.preferStringValue ? this.getValue() : this.getBigDecimalValue();
        if (this.autoclearOnOK) {
            this.clear();
        }
        this.ok(finalValue);
    }

    public void ok(Object value) {
        Events.postEvent((String)"onOK", (Component)this, (Object)value);
    }

    public void appendValue(String delta) {
        if (delta != null) {
            if (this.value == null) {
                this.value = "";
            }
            this.value = this.value + delta;
            this.syncDisplay();
        }
    }

    public void appendValue(Number number) {
        if (number != null) {
            this.appendValue(String.valueOf(number));
        }
    }

    public String getValue() {
        return this.value;
    }

    public long getLongValue() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public BigDecimal getBigDecimalValue() {
        try {
            return new BigDecimal(this.value);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public void setValue(String value) {
        this.value = value;
        this.syncDisplay();
    }

    public void setDisplayLabel(String id) {
        Component component = this.getFellow(id);
        if (component instanceof Label) {
            this.displayLabel = (Label)component;
        }
    }

    public void setDisplayBox(String id) {
        Component component = this.getFellow(id);
        if (component instanceof InputElement) {
            this.displayBox = (InputElement)component;
        }
    }

    private void syncDisplay() {
        if (this.displayLabel != null) {
            String lblValue = this.getValue();
            if (this.labelFormat != null) {
                lblValue = StringUtils.format((Number)this.getBigDecimalValue(), (String)this.labelFormat);
            }
            this.displayLabel.setValue(lblValue);
        }
        if (this.displayBox != null) {
            if (this.displayBox instanceof Decimalbox) {
                ((Decimalbox)this.displayBox).setValue(this.getBigDecimalValue());
            } else {
                this.displayBox.setRawValue((Object)this.value);
            }
        }
    }

    public boolean isAutoclearOnOK() {
        return this.autoclearOnOK;
    }

    public void setAutoclearOnOK(boolean autoclearOnOK) {
        this.autoclearOnOK = autoclearOnOK;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
    }

    public List<Key> getDefaultKeys() {
        return this.defaultKeys;
    }

    public void setDefaultKeys(List<Key> defaultKeys) {
        this.defaultKeys = defaultKeys;
    }

    public boolean isPreferStringValue() {
        return this.preferStringValue;
    }

    public void setPreferStringValue(boolean preferStringValue) {
        this.preferStringValue = preferStringValue;
    }

    public static Keypad show(String title, EventListener<Event> onOk) {
        Vlayout vlayout = new Vlayout();
        Label label = new Label();
        label.setZclass("kp-label");
        Keypad pad = new Keypad(label);
        pad.setLabelFormat("###,###");
        vlayout.appendChild((Component)label);
        vlayout.appendChild((Component)pad);
        pad.setWidth("100%");
        pad.setHeight("400px");
        Window win = ZKUtil.showDialog(title, (Component)vlayout, "300px", null);
        pad.addEventListener("onOK", evt -> {
            win.detach();
            onOk.onEvent(evt);
        });
        return pad;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.updateStatus();
    }

    protected void updateStatus() {
        this.queryAll("button").forEach(e -> {
            Button btn = (Button)e;
            btn.setDisabled(this.isDisabled());
        });
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Div getDisplayRegion() {
        return this.displayRegion;
    }

    public InputElement getDisplayBox() {
        return this.displayBox;
    }

    public Label getDisplayLabel() {
        return this.displayLabel;
    }

    public Key findKey(String labelOrValue) {
        return this.defaultKeys.stream().filter(k -> labelOrValue.equals(k.getValue()) || labelOrValue.equals(k.getLabel())).findFirst().orElse(null);
    }

    public void replaceKey(String labelOrValue, Key newKey) {
        Key originalKey = this.findKey(labelOrValue);
        if (originalKey != null) {
            this.defaultKeys.add(this.defaultKeys.indexOf(originalKey), newKey);
            this.defaultKeys.remove(originalKey);
            this.init();
        }
    }

    static {
        ComponentAliasIndex.getInstance().add(Keypad.class);
        BindingComponentIndex.getInstance().put("value", (Class)Keypad.class);
        NEW_ROW = new Key();
    }

    public static class Key {
        private String label;
        private String value;
        private String icon;
        private int colSpan = 1;
        private int rowSpan = 1;
        private String sclass = "";
        private EventListener<Event> command;

        public Key() {
        }

        public Key(String value) {
            this.value = value;
            this.label = value;
        }

        public Key(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public Key(String value, int colSpan, int rowSpan) {
            this(value);
            this.colSpan = colSpan;
            this.rowSpan = rowSpan;
        }

        public String getLabel() {
            return this.label;
        }

        public Key setLabel(String label) {
            this.label = label;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Key setValue(String value) {
            this.value = value;
            return this;
        }

        public String getIcon() {
            return this.icon;
        }

        public Key setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public String getSclass() {
            return this.sclass;
        }

        public Key setSclass(String sclass) {
            this.sclass = sclass;
            return this;
        }

        public EventListener<Event> getCommand() {
            return this.command;
        }

        public Key setCommand(EventListener<Event> command) {
            this.command = command;
            return this;
        }
    }

    class KeyButton
    extends Button {
        private final Key key;

        public KeyButton(Key key) {
            this.key = key;
            this.setZclass("kp-key kp-" + key.getLabel() + "key " + key.getSclass());
            if (key.getIcon() != null) {
                this.setIconSclass(key.getIcon());
            } else {
                this.setLabel(key.getLabel());
            }
            if (key.getCommand() != null) {
                this.addEventListener("onClick", key.getCommand());
            } else {
                this.addEventListener("onClick", e -> Keypad.this.appendValue(key.getValue()));
            }
            this.setWidth("100%");
            this.setHeight("100%");
        }

        public Key getKey() {
            return this.key;
        }
    }
}

