/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Label;
import org.zkoss.zul.Progressmeter;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;
import tools.dynamia.commons.ClassMessages;
import tools.dynamia.commons.Messages;
import tools.dynamia.commons.StopWatch;
import tools.dynamia.integration.ProgressMonitor;
import tools.dynamia.zk.util.LongOperation;
import tools.dynamia.zk.util.ZKUtil;

public class LongOperationMonitorWindow
extends Window {
    private static final long serialVersionUID = -2630380982547205553L;
    public static final int DEFAULT_REFRESH_RATE = 2000;
    private final ClassMessages messages = ClassMessages.get(LongOperationMonitorWindow.class);
    private final ProgressMonitor monitor;
    private Progressmeter progress;
    private String messageTemplate = this.messages.get("DefaultProgressMessage");
    private int refreshRate;
    private final LongOperation longOperation;
    private Caption titleCaption;
    private Label messageLabel;

    public LongOperationMonitorWindow(LongOperation longOperation, ProgressMonitor monitor) {
        this(longOperation, monitor, 2000);
    }

    public LongOperationMonitorWindow(LongOperation longOperation, ProgressMonitor monitor, int refreshRate) {
        this.longOperation = longOperation;
        this.monitor = monitor;
        this.refreshRate = refreshRate;
        this.initUI();
        this.initMonitor();
        this.setPage(ZKUtil.getFirstPage());
    }

    public static LongOperationMonitorWindow show(String title, LongOperation longOperation, ProgressMonitor monitor) {
        return LongOperationMonitorWindow.show(title, longOperation, monitor, 2000);
    }

    public static LongOperationMonitorWindow show(String title, LongOperation longOperation, ProgressMonitor monitor, int refreshRate) {
        LongOperationMonitorWindow wind = new LongOperationMonitorWindow(longOperation, monitor, refreshRate);
        wind.setTitle(title);
        wind.setPosition("center");
        wind.doModal();
        return wind;
    }

    private void initMonitor() {
        if (this.monitor != null) {
            StopWatch stopWatch = new StopWatch((long)this.refreshRate);
            this.monitor.onProgressChanged(evt -> {
                if (stopWatch.now() && !this.monitor.isStopped() || this.monitor.getCurrent() >= this.monitor.getMax()) {
                    this.longOperation.updateUI(() -> {
                        this.progress.setValue(evt.getPercent());
                        this.progress.setTooltiptext(evt.getPercent() + "%");
                        this.messageLabel.setValue(evt.getMessage());
                        this.setTitle(Messages.format((String)this.messageTemplate, (Object[])new Object[]{evt.getCurrent(), evt.getMax(), evt.getPercent()}));
                    });
                }
            });
            this.longOperation.onCleanup(this::finish);
        }
    }

    private void finish() {
        if (ZKUtil.isInEventListener()) {
            this.detach();
        } else {
            this.longOperation.updateUI(() -> ((LongOperationMonitorWindow)this).detach());
        }
    }

    private void initUI() {
        this.setWidth("500px");
        this.setClosable(true);
        this.setStyle("padding: 10px");
        this.titleCaption = new Caption("");
        this.titleCaption.setIconSclass("fa fa-refresh fa-spin fa-2x");
        this.titleCaption.setParent((Component)this);
        Vlayout layout = new Vlayout();
        layout.setHflex("1");
        layout.setParent((Component)this);
        this.progress = new Progressmeter();
        this.progress.setHflex("2");
        this.progress.setParent((Component)layout);
        this.progress.setValue(0);
        Div messageContainer = new Div();
        messageContainer.setStyle("text-align: center");
        this.messageLabel = new Label();
        this.messageLabel.setParent((Component)messageContainer);
        messageContainer.setParent((Component)layout);
        Hlayout hlayout = new Hlayout();
        hlayout.setHflex("1");
        hlayout.setParent((Component)layout);
        hlayout.setVisible(false);
        Label confirmStopLabel = new Label(this.messages.get("ConfirmStopProcess"));
        confirmStopLabel.setStyle("font-weight:bold");
        confirmStopLabel.setParent((Component)hlayout);
        Button yesBtn = new Button(this.messages.get("yes"));
        yesBtn.setZclass("btn btn-success  btn-sm");
        yesBtn.setParent((Component)hlayout);
        yesBtn.addEventListener("onClick", evt -> this.stop());
        Button noBtn = new Button(this.messages.get("no"));
        noBtn.setZclass("btn btn-danger btn-sm");
        noBtn.setParent((Component)hlayout);
        noBtn.addEventListener("onClick", evt -> hlayout.setVisible(false));
        this.addEventListener("onClose", evt -> {
            evt.stopPropagation();
            hlayout.setVisible(true);
        });
    }

    private void stop() {
        try {
            this.longOperation.onFinish(null);
            this.monitor.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.finish();
        }
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public void setTitle(String title) {
        this.titleCaption.setLabel(title);
    }
}

