/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.function.Consumer;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Messagebox;
import tools.dynamia.commons.Callback;
import tools.dynamia.commons.Messages;
import tools.dynamia.ui.MessageDisplayer;
import tools.dynamia.ui.MessageType;
import tools.dynamia.zk.util.ZKUtil;

public class MessageDialog
implements MessageDisplayer {
    public void showMessage(String message) {
        this.showMessage(message, "Mensaje", MessageType.NORMAL);
    }

    public void showMessage(String message, MessageType type) {
        this.showMessage(message, "Message", type);
    }

    public void showMessage(String message, String title, MessageType type) {
        String icon = Messagebox.NONE;
        switch (type) {
            case NORMAL: {
                icon = Messagebox.NONE;
                break;
            }
            case ERROR: 
            case CRITICAL: {
                icon = "z-messagebox-icon z-messagebox-error";
                break;
            }
            case INFO: 
            case SPECIAL: {
                icon = "z-messagebox-icon z-messagebox-information";
                break;
            }
            case WARNING: {
                icon = "z-messagebox-icon z-messagebox-exclamation";
            }
        }
        Messagebox.show((String)message, (String)title, (int)1, (String)icon);
    }

    public void showQuestion(String message, String title, Callback onYesResponse) {
        title = this.fixTitle(title);
        ZKUtil.showQuestion(message, title, (EventListener<Messagebox.ClickEvent>)((EventListener)t -> {
            if (t.getButton() == Messagebox.Button.YES) {
                onYesResponse.doSomething();
            }
        }));
    }

    public void showQuestion(String message, String title, Callback onYesResponse, Callback onNoResponseCallback) {
        title = this.fixTitle(title);
        ZKUtil.showQuestion(message, title, (EventListener<Messagebox.ClickEvent>)((EventListener)t -> {
            if (t.getButton() == Messagebox.Button.YES) {
                onYesResponse.doSomething();
            } else if (t.getButton() == Messagebox.Button.NO) {
                onNoResponseCallback.doSomething();
            }
        }));
    }

    private String fixTitle(String title) {
        if (title != null && !title.isEmpty()) {
            return title;
        }
        return Messages.get(MessageDialog.class, (String)"areyousure");
    }

    public <T> void showInput(String title, Class<T> valueClass, Consumer<T> onValue) {
        this.showInput(title, valueClass, null, onValue);
    }

    public <T> void showInput(String title, Class<T> valueClass, T defaultValue, Consumer<T> onValue) {
        ZKUtil.showInputDialog(title, valueClass, defaultValue, evt -> onValue.accept(evt.getData()));
    }
}

