/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.util.Clients;
import tools.dynamia.ui.MessageType;
import tools.dynamia.zk.ui.MessageDialog;

public class MessageNotification
extends MessageDialog {
    private String position = "bottom_right";
    private int timeout = 3000;

    public MessageNotification() {
    }

    public MessageNotification(Map<String, Object> config) {
        Object time;
        Object pos = config.get("position");
        if (pos != null) {
            this.position = "" + pos;
        }
        if ((time = config.get("timeout")) != null) {
            try {
                this.timeout = Integer.parseInt("" + time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void showMessage(String message) {
        this.showMessage(message, "Mensaje", MessageType.INFO);
    }

    @Override
    public void showMessage(String message, MessageType type) {
        this.showMessage(message, "Message", type);
    }

    @Override
    public void showMessage(String message, String title, MessageType type) {
        this.showMessage(message, title, type, null);
    }

    public void showMessage(String message, String title, MessageType type, Object source) {
        if (type == MessageType.NORMAL || type == MessageType.SPECIAL) {
            type = MessageType.INFO;
        }
        String pos = this.position;
        Component ref = null;
        if (source instanceof Component) {
            ref = (Component)source;
            pos = "after_center";
        }
        Clients.showNotification((String)message, (String)type.toString().toLowerCase(), (Component)ref, (String)pos, (int)this.timeout, (boolean)true);
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

