/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Window;
import tools.dynamia.ui.MessageType;
import tools.dynamia.zk.ui.MessageDialog;
import tools.dynamia.zk.util.ZKUtil;

public class MessagePopup
extends MessageDialog {
    private String posicion = "right,bottom";
    private int timeout = 4000;

    public MessagePopup() {
    }

    public MessagePopup(Map<String, Object> config) {
        Object time;
        Object pos = config.get("position");
        if (pos != null) {
            this.posicion = "" + pos;
        }
        if ((time = config.get("timeout")) != null) {
            try {
                this.timeout = Integer.parseInt("" + time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void showMessage(String message) {
        this.showMessage(message, "Mensaje", MessageType.NORMAL);
    }

    @Override
    public void showMessage(String message, MessageType type) {
        this.showMessage(message, "Message", type);
    }

    @Override
    public void showMessage(String message, String title, MessageType type) {
        Timer timer = new Timer(this.timeout);
        Window window = new Window();
        window.setPosition(this.posicion);
        window.setSclass("msg-popup msg-popup-" + type.name().toLowerCase());
        window.setPage(ZKUtil.getFirstPage());
        window.setClosable(true);
        window.setVisible(true);
        window.doPopup();
        timer.setParent((Component)window);
        timer.addEventListener("onTimer", event -> window.detach());
        Vbox contenido = new Vbox();
        contenido.setStyle("margin-left: 10px;margin-top: 5px");
        contenido.setParent((Component)window);
        contenido.setWidth("98%");
        contenido.setHeight("100%");
        Hbox superior = new Hbox();
        superior.setParent((Component)contenido);
        superior.setWidth("100%");
        if (title == null) {
            title = "Mensage";
        }
        Label titulo = new Label(title);
        titulo.setParent((Component)superior);
        titulo.setSclass("msg-popup-title");
        Div close = new Div();
        close.setParent((Component)superior);
        close.setSclass("msg-popup-close");
        close.addEventListener("onClick", event -> window.detach());
        Hbox inferior = new Hbox();
        inferior.setParent((Component)contenido);
        inferior.setWidth("100%");
        inferior.setWidth("100%");
        Div icon = new Div();
        icon.setParent((Component)inferior);
        icon.setSclass("msg-popup-icon msg-popup-icon-" + type.name().toLowerCase());
        Label msg = new Label(message);
        msg.setParent((Component)inferior);
        msg.setMultiline(true);
        msg.setSclass("msg-popup-message");
    }
}

