/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.List;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zul.Combobox;
import tools.dynamia.commons.BeanSorter;
import tools.dynamia.navigation.NavigationManager;
import tools.dynamia.navigation.Page;
import tools.dynamia.zk.util.ZKUtil;

public class PageFinder
extends Combobox {
    private static final long serialVersionUID = 6551599841117590635L;

    public PageFinder() {
        this.configure();
    }

    public PageFinder(String value) {
        super(value);
        this.configure();
    }

    private void configure() {
        this.setButtonVisible(false);
        this.refresh("");
    }

    public void onChanging(InputEvent event) {
        this.refresh(event.getValue());
    }

    public void onSelect(SelectEvent event) {
        Page page = (Page)this.getSelectedItem().getValue();
        if (page != null) {
            NavigationManager.getCurrent().setCurrentPage(page);
        }
    }

    public void setValue(String value) throws WrongValueException {
        super.setValue(value);
        this.refresh(value);
    }

    private void refresh(String val) {
        if (val != null && !val.isEmpty() && val.length() > 2) {
            List pages = NavigationManager.getCurrent().findPagesByName(val);
            BeanSorter sorter = new BeanSorter("name");
            sorter.setAscending(true);
            sorter.sort(pages);
            ZKUtil.fillCombobox((Combobox)this, pages, false);
            this.open();
        } else {
            this.getChildren().clear();
            this.close();
        }
    }
}

