/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Bandbox;
import org.zkoss.zul.Bandpopup;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.integration.Containers;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;

public class ProviderMultipickerBox
extends Bandbox {
    private static final long serialVersionUID = 4710970528102748639L;
    private String selected;
    private String className;
    private String idField = "id";
    private String nameField = "name";
    private Class<?> providerClass;
    private final Listbox itemsList;

    public ProviderMultipickerBox() {
        this.setReadonly(true);
        this.setButtonVisible(true);
        Bandpopup bandpopup = new Bandpopup();
        bandpopup.setHflex("min");
        bandpopup.setVflex("min");
        this.itemsList = new Listbox();
        this.itemsList.setHeight("200px");
        this.itemsList.setMultiple(true);
        this.itemsList.setCheckmark(true);
        this.itemsList.setItemRenderer((item, data, index) -> {
            try {
                String id = BeanUtils.invokeGetMethod((Object)data, (String)this.idField).toString();
                String name = BeanUtils.invokeGetMethod((Object)data, (String)this.nameField).toString();
                item.setLabel(StringUtils.capitalize((String)name));
                item.setValue((Object)id);
            }
            catch (Exception e) {
                throw new UiException("Error rendering item for " + this, (Throwable)e);
            }
        });
        this.itemsList.addEventListener("onSelect", e -> this.updateLabel());
        bandpopup.appendChild((Component)this.itemsList);
        this.appendChild((Component)bandpopup);
        this.addEventListener("onFulfill", (EventListener<? extends Event>)((EventListener)e -> this.updateLabel()));
    }

    private void updateLabel() {
        if (this.itemsList.getSelectedItems().isEmpty()) {
            this.setValue("");
        } else {
            String label = this.itemsList.getSelectedItems().stream().map(Listitem::getLabel).collect(Collectors.joining(", "));
            this.setValue(label);
        }
    }

    public boolean addEventListener(String evtnm, EventListener<? extends Event> listener) {
        if ("onSelect".equals(evtnm)) {
            return this.itemsList.addEventListener(evtnm, listener);
        }
        return super.addEventListener(evtnm, listener);
    }

    private void initModel() {
        if (this.providerClass != null) {
            try {
                Collection implementations = Containers.get().findObjects(this.providerClass);
                ListModelList model = new ListModelList(implementations);
                model.setMultiple(true);
                this.itemsList.setModel((ListModel)model);
                this.itemsList.setMultiple(true);
            }
            catch (Exception e) {
                throw new UiException("Cannot init model for " + this + ". Provider class name: " + this.className, (Throwable)e);
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
        try {
            this.providerClass = Class.forName(className);
            this.initModel();
        }
        catch (ClassNotFoundException e) {
            throw new UiException("Invalid class name for " + this, (Throwable)e);
        }
    }

    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
        this.initModel();
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
        this.initModel();
    }

    public String getSelected() {
        this.selected = null;
        if (this.itemsList.getSelectedItems() != null && !this.itemsList.getSelectedItems().isEmpty()) {
            this.selected = this.itemsList.getSelectedItems().stream().map(it -> it.getValue().toString()).collect(Collectors.joining(","));
        }
        return this.selected;
    }

    public void setSelected(String selected) {
        if (selected != this.selected) {
            this.selected = selected;
            try {
                String[] values = null;
                if (selected != null) {
                    values = selected.contains(",") ? selected.split(",") : new String[]{selected};
                }
                if (values != null) {
                    ListModelList model = (ListModelList)this.itemsList.getModel();
                    for (String value : values) {
                        Optional<Object> provider = Containers.get().findObjects(this.providerClass).stream().filter(p -> value.trim().equals(BeanUtils.invokeGetMethod((Object)p, (String)this.idField))).findFirst();
                        if (!provider.isPresent()) continue;
                        model.addToSelection(provider.get());
                    }
                }
                this.itemsList.renderAll();
                this.updateLabel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        ComponentAliasIndex.getInstance().add("providermultipickerbox", ProviderMultipickerBox.class);
        BindingComponentIndex.getInstance().put("selected", (Class)ProviderMultipickerBox.class);
    }
}

