/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModelList;
import tools.dynamia.commons.BeanSorter;
import tools.dynamia.commons.BeanUtils;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.integration.Containers;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;
import tools.dynamia.zk.util.ZKUtil;

public class ProviderPickerBox
extends Combobox {
    private static final long serialVersionUID = 4710970528102748639L;
    private String selected;
    private String className;
    private String idField = "id";
    private String nameField = "name";
    private Class<?> providerClass;

    public ProviderPickerBox() {
        this.setReadonly(true);
        this.setItemRenderer((item, data, index) -> {
            try {
                String id = BeanUtils.invokeGetMethod((Object)data, (String)this.idField).toString();
                String name = BeanUtils.invokeGetMethod((Object)data, (String)this.nameField).toString();
                item.setLabel(StringUtils.capitalize((String)name));
                item.setValue((Object)id);
            }
            catch (Exception e) {
                throw new UiException("Error rendering item for " + this, (Throwable)e);
            }
        });
    }

    private void initModel() {
        if (this.providerClass != null) {
            try {
                Collection implementations = Containers.get().findObjects(this.providerClass);
                try {
                    ArrayList sorted = new ArrayList(implementations);
                    BeanSorter sorter = new BeanSorter(this.nameField);
                    sorter.sort(sorted);
                    ZKUtil.fillCombobox((Combobox)this, sorted, true);
                }
                catch (Exception e) {
                    ZKUtil.fillCombobox((Combobox)this, implementations, true);
                }
            }
            catch (Exception e) {
                throw new UiException("Cannot init model for " + this + ". Provider class name: " + this.className, (Throwable)e);
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
        try {
            this.providerClass = Class.forName(className);
            this.initModel();
        }
        catch (ClassNotFoundException e) {
            throw new UiException("Invalid class name for " + this, (Throwable)e);
        }
    }

    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
        this.initModel();
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
        this.initModel();
    }

    public String getSelected() {
        this.selected = null;
        if (this.getSelectedItem() != null) {
            this.selected = (String)this.getSelectedItem().getValue();
        }
        return this.selected;
    }

    public void setSelected(String selected) {
        if (selected != this.selected) {
            this.selected = selected;
            try {
                Optional<Object> provider = Containers.get().findObjects(this.providerClass).stream().filter(p -> selected.equals(BeanUtils.invokeGetMethod((Object)p, (String)this.idField))).findFirst();
                if (provider.isPresent()) {
                    ListModelList model = (ListModelList)this.getModel();
                    model.addToSelection(provider.get());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        ComponentAliasIndex.getInstance().add("providerpickerbox", ProviderPickerBox.class);
        BindingComponentIndex.getInstance().put("selected", (Class)ProviderPickerBox.class);
    }
}

