/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Toolbarbutton;
import tools.dynamia.commons.Messages;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.io.FileInfo;
import tools.dynamia.io.IOUtils;
import tools.dynamia.io.ImageUtil;
import tools.dynamia.ui.MessageType;
import tools.dynamia.ui.UIMessages;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ComponentAliasIndex;

public class Uploadlink
extends Toolbarbutton {
    private static final long serialVersionUID = 3854375081463695335L;
    public static String ON_FILE_UPLOADED;
    private String uploadDirectory = System.getProperty("java.io.tmpdir") + "//" + System.currentTimeMillis();
    private int maxSize = 300;
    private String fixedFileName;
    private boolean imageOnly;
    private int imageMaxWidth;
    private int imageMaxHeight;
    private FileInfo uploadedFile;
    private String format;
    private String contentType;
    private boolean imageAutoJpg;

    public Uploadlink() {
        this.configureLabel();
        this.setClass("uploadLink");
        this.setUpload("true");
    }

    public void onUpload(UploadEvent event) throws Exception {
        this.processUploadFile(event);
    }

    private void processUploadFile(UploadEvent event) throws IOException {
        Media media = event.getMedia();
        if (this.imageOnly && !this.isImage(media.getName())) {
            UIMessages.showMessage((String)Messages.get(Uploadlink.class, (String)"uploadOnlyImageAllowed"), (MessageType)MessageType.ERROR);
            return;
        }
        if (this.format != null && !media.getFormat().equals(this.format)) {
            UIMessages.showMessage((String)Messages.get(Uploadlink.class, (String)"uploadNoFormatAllowed", (Object[])new Object[]{this.format}), (MessageType)MessageType.ERROR);
            return;
        }
        if (this.contentType != null && !media.getContentType().equals(this.contentType)) {
            UIMessages.showMessage((String)Messages.get(Uploadlink.class, (String)"uploadNoContentTypeAllowed", (Object[])new Object[]{this.contentType}), (MessageType)MessageType.ERROR);
            return;
        }
        if (this.uploadDirectory != null) {
            String fileName = this.fixedFileName == null ? media.getName() : this.fixedFileName;
            File dir = new File(this.uploadDirectory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File outputFile = new File(dir, fileName);
            if (media.isBinary()) {
                IOUtils.copy((InputStream)media.getStreamData(), (File)outputFile);
            } else {
                IOUtils.copy((byte[])media.getStringData().getBytes(), (File)outputFile);
            }
            outputFile = this.processImage(fileName, dir, outputFile);
            this.uploadedFile = new FileInfo(outputFile);
            UIMessages.showMessage((String)Messages.get(Uploadlink.class, (String)"uploadSuccess", (Object[])new Object[]{fileName}));
            this.configureLabel();
            this.onFileUpload();
            Events.postEvent((Event)new Event(ON_FILE_UPLOADED, (Component)this, (Object)this.uploadedFile));
        }
    }

    private File processImage(String fileName, File dir, File outputFile) {
        if (this.imageOnly && this.imageMaxHeight > 0 && this.imageMaxWidth > 0) {
            int w = ImageUtil.getWidth((File)outputFile);
            int h = ImageUtil.getHeight((File)outputFile);
            if (h > this.imageMaxHeight || w > this.imageMaxWidth) {
                File newfile = new File(dir, "rzd_" + fileName);
                ImageUtil.resizeImage((File)outputFile, (File)newfile, (String)StringUtils.getFilenameExtension((String)fileName), (int)this.imageMaxWidth, (int)this.imageMaxHeight);
                outputFile = newfile;
            }
        }
        if (this.imageOnly && this.imageAutoJpg) {
            outputFile = ImageUtil.convertPngToJpg((File)outputFile);
        }
        return outputFile;
    }

    private boolean isImage(String name) {
        if (name == null) {
            return false;
        }
        return (name = name.toLowerCase()).endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    protected void onFileUpload() {
    }

    public FileInfo getUploadedFile() {
        return this.uploadedFile;
    }

    public void setUploadedFile(FileInfo uploadedFile) {
        this.uploadedFile = uploadedFile;
        this.configureLabel();
    }

    private void configureLabel() {
        String label = null;
        label = !this.isImageOnly() ? Messages.get(Uploadlink.class, (String)"upload") : Messages.get(Uploadlink.class, (String)"uploadImage");
        this.setTooltiptext(label);
        if (this.uploadedFile != null) {
            label = this.uploadedFile.getName();
        }
        this.setLabel(label);
    }

    public String getUploadDirectory() {
        return this.uploadDirectory;
    }

    public void setUploadDirectory(String uploadDirectory) {
        this.uploadDirectory = uploadDirectory;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public String getFixedFileName() {
        return this.fixedFileName;
    }

    public void setFixedFileName(String fixedFileName) {
        this.fixedFileName = fixedFileName;
    }

    public boolean isImageOnly() {
        return this.imageOnly;
    }

    public void setImageOnly(boolean imageOnly) {
        this.imageOnly = imageOnly;
        this.configureLabel();
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getImageMaxWidth() {
        return this.imageMaxWidth;
    }

    public void setImageMaxWidth(int imageMaxWidth) {
        this.imageMaxWidth = imageMaxWidth;
    }

    public int getImageMaxHeight() {
        return this.imageMaxHeight;
    }

    public void setImageMaxHeight(int imageMaxHeight) {
        this.imageMaxHeight = imageMaxHeight;
    }

    public boolean isImageAutoJpg() {
        return this.imageAutoJpg;
    }

    public void setImageAutoJpg(boolean imageAutoJpg) {
        this.imageAutoJpg = imageAutoJpg;
    }

    static {
        ComponentAliasIndex.getInstance().add(Uploadlink.class);
        BindingComponentIndex.getInstance().put("uploadedFile", (Class)Uploadlink.class);
        ON_FILE_UPLOADED = "onFileUploaded";
    }
}

