/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.util;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.springframework.core.task.TaskExecutor;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import tools.dynamia.commons.Callback;

public class LongOperation
implements Runnable {
    private String desktopId;
    private DesktopCache desktopCache;
    private Thread thread;
    private TaskExecutor taskExecutor;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private Callback onFinishCallbak;
    private Callback onCancelCallback;
    private Consumer<Exception> onExceptionConsumer;
    private Callback onCleanupCallback;
    private Callback executeCallback;
    private Callback onStartCallback;
    private final UUID taskId = UUID.randomUUID();

    public LongOperation() {
    }

    public LongOperation(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public LongOperation onStart(Callback onStart) {
        this.onStartCallback = onStart;
        return this;
    }

    public LongOperation execute(Callback executeCallback) {
        this.executeCallback = executeCallback;
        return this;
    }

    public LongOperation onFinish(Callback onFinishCallback) {
        this.onFinishCallbak = onFinishCallback;
        return this;
    }

    public LongOperation onCancel(Callback onCancelCallback) {
        this.onCancelCallback = onCancelCallback;
        return this;
    }

    public LongOperation onException(Consumer<Exception> onExceptionConsumer) {
        this.onExceptionConsumer = onExceptionConsumer;
        return this;
    }

    public LongOperation onCleanup(Callback onCleanupCallback) {
        this.onCleanupCallback = onCleanupCallback;
        return this;
    }

    public final void cancel() {
        this.cancelled.set(true);
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public final boolean isCancelled() {
        return this.cancelled.get();
    }

    protected final void activate() throws InterruptedException {
        Executions.activate((Desktop)this.getDesktop());
    }

    protected final void deactivate() {
        Executions.deactivate((Desktop)this.getDesktop());
    }

    protected final void checkCancelled() throws InterruptedException {
        if (Thread.currentThread() != this.thread && this.taskExecutor == null) {
            throw new IllegalStateException("this method can only be called in the worker thread (i.e. during execute)");
        }
        boolean interrupted = Thread.interrupted();
        if (interrupted || this.cancelled.get()) {
            this.cancelled.set(true);
            throw new InterruptedException();
        }
    }

    public final LongOperation start() {
        this.desktopId = Executions.getCurrent().getDesktop().getId();
        this.desktopCache = ((WebAppCtrl)WebApps.getCurrent()).getDesktopCache(Sessions.getCurrent());
        this.enableServerPushForThisTask();
        if (this.taskExecutor == null) {
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            this.taskExecutor.execute((Runnable)this);
        }
        return this;
    }

    @Override
    public final void run() {
        try {
            try {
                this.runCallback(this.onStartCallback);
                this.checkCancelled();
                this.execute();
                this.checkCancelled();
                this.activate();
                this.finish();
                this.deactivate();
            }
            catch (InterruptedException e) {
                try {
                    this.cancelled.set(true);
                    this.activate();
                    this.runCallback(this.onCancelCallback);
                    this.deactivate();
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException("interrupted onCancel handling", e1);
                }
            }
            catch (Exception rte) {
                try {
                    this.activate();
                    if (this.onExceptionConsumer != null) {
                        this.onExceptionConsumer.accept(rte);
                    }
                    this.deactivate();
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException("interrupted onException handling", e1);
                }
                throw rte;
            }
        }
        finally {
            this.updateUI(this.onCleanupCallback);
            this.disableServerPushForThisTask();
        }
    }

    protected void finish() {
        this.runCallback(this.onFinishCallbak);
    }

    protected void execute() {
        this.runCallback(this.executeCallback);
    }

    protected void runCallback(Callback callback) {
        if (callback != null) {
            callback.doSomething();
        }
    }

    private void enableServerPushForThisTask() {
        ((DesktopCtrl)this.getDesktop()).enableServerPush(true, (Serializable)this.taskId);
    }

    private void disableServerPushForThisTask() {
        ((DesktopCtrl)this.getDesktop()).enableServerPush(false, (Serializable)this.taskId);
    }

    private Desktop getDesktop() {
        return this.desktopCache.getDesktop(this.desktopId);
    }

    public void updateUI(Callback callback) {
        try {
            this.activate();
            this.runCallback(callback);
            this.deactivate();
        }
        catch (InterruptedException | DesktopUnavailableException e) {
            e.printStackTrace();
        }
    }

    public static LongOperation create() {
        return new LongOperation();
    }

    public static LongOperation create(TaskExecutor taskExecutor) {
        return new LongOperation(taskExecutor);
    }
}

