/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.util;

import org.zkoss.zul.Paging;
import org.zkoss.zul.ext.Paginal;
import tools.dynamia.commons.Callback;
import tools.dynamia.domain.query.DataPaginator;
import tools.dynamia.zk.util.ZKUtil;

public class PaginationController {
    private final Paging paginator;
    private final Callback callback;
    private DataPaginator dataPaginator;

    public PaginationController(Paging paging, Callback callback) {
        this.paginator = paging;
        this.callback = callback;
        this.configurePaginator();
    }

    public void init() {
        if (this.dataPaginator != null) {
            this.dataPaginator.reset();
        }
        this.update();
    }

    public void update() {
        ZKUtil.synchronizePaginator(this.dataPaginator, (Paginal)this.paginator);
    }

    private void configurePaginator() {
        if (this.paginator != null) {
            this.dataPaginator = new DataPaginator();
            this.update();
            this.paginator.addEventListener("onPaging", evt -> {
                this.update();
                if (this.callback != null) {
                    this.callback.doSomething();
                }
            });
        }
    }

    public DataPaginator getDataPaginator() {
        return this.dataPaginator;
    }
}

