/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.util;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.task.TaskExecutor;
import tools.dynamia.zk.util.LongOperation;

public class ResultLongOperation<R>
extends LongOperation {
    private R result;
    private Supplier<R> executeSupplier;
    private Consumer<R> onResultConsumer;

    public ResultLongOperation() {
    }

    public ResultLongOperation(TaskExecutor taskExecutor) {
        super(taskExecutor);
    }

    public ResultLongOperation<R> executeWithResult(Supplier<R> supplier) {
        this.executeSupplier = supplier;
        return this;
    }

    public ResultLongOperation<R> onResult(Consumer<R> onResultConsumer) {
        this.onResultConsumer = onResultConsumer;
        return this;
    }

    @Override
    protected void execute() {
        this.result = this.executeSupplier.get();
    }

    @Override
    protected void finish() {
        if (this.onResultConsumer != null) {
            this.onResultConsumer.accept(this.result);
        }
        super.finish();
    }

    public static <R> ResultLongOperation<R> create(Class<R> expectedClass) {
        return new ResultLongOperation<R>();
    }

    public static <R> ResultLongOperation<R> create(Class<R> expectedClass, TaskExecutor taskExecutor) {
        return new ResultLongOperation<R>(taskExecutor);
    }
}

