/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.util;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.DefaultBinder;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.zk.BindingComponentIndex;
import tools.dynamia.zk.ui.CoolLabel;
import tools.dynamia.zk.util.ZKUtil;

public class ZKBindingUtil {
    private static final String CONVERTER = "converter";
    private static final String VALUE = "value";
    private static final LoggingService logger = new SLF4JLoggingService(ZKBindingUtil.class);
    public static final String KEY_EXP_PREFIX = "_ExpPrefix";

    public static Binder createBinder() {
        return new DefaultBinder();
    }

    public static void initBinder(Binder binder, Component rootComponent, Object viewModel) {
        binder.init(rootComponent, viewModel, null);
    }

    public static void initBinder(Binder binder, Component rootComponent, Object viewModel, Map<String, Object> initArgs) {
        binder.init(rootComponent, viewModel, initArgs);
    }

    public static void bindBean(Component rootComponent, String name, Object bean) {
        rootComponent.setAttribute(name, bean);
    }

    public static void bindComponent(Binder binder, Component component, String expression, String converterExpression) {
        ZKBindingUtil.bindComponent(binder, component, null, expression, converterExpression);
    }

    public static void bindComponent(Binder binder, Component component, Map bindindingMap) {
        if (bindindingMap == null) {
            logger.warn("Binding map is null, nothing to do");
            return;
        }
        Object prefix = "";
        if (bindindingMap.containsKey(KEY_EXP_PREFIX)) {
            prefix = bindindingMap.get(KEY_EXP_PREFIX) + ".";
            bindindingMap.remove(KEY_EXP_PREFIX);
        }
        Iterator iterator = bindindingMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            String bindingAttribute = entry.getKey().toString();
            String expression = null;
            String converter = null;
            if (entry.getValue() instanceof Map) {
                Map bindingDetail = (Map)entry.getValue();
                expression = (String)bindingDetail.get(VALUE);
                converter = (String)bindingDetail.get(CONVERTER);
            } else if (entry.getValue() instanceof String) {
                expression = entry.getValue().toString();
            }
            if (expression == null || expression.isEmpty()) continue;
            if (expression.contains((CharSequence)prefix)) {
                prefix = "";
            }
            ZKBindingUtil.bindComponent(binder, component, bindingAttribute, (String)prefix + expression, converter);
        }
    }

    public static void bindComponent(Binder binder, Component component, String bindingAttribute, String expression, String converterExpression) {
        ZKBindingUtil.bindComponent(binder, component, bindingAttribute, expression, converterExpression, null);
    }

    public static void bindComponent(Binder binder, Component component, String bindingAttribute, String expression, String converterExpression, String[] saveAfterCmds) {
        if (binder == null) {
            logger.warn("Trying to bind component but Binder is null");
            return;
        }
        if (bindingAttribute == null) {
            bindingAttribute = BindingComponentIndex.getInstance().getAttribute(component.getClass());
        }
        if (converterExpression != null) {
            try {
                Class.forName((String)converterExpression);
                converterExpression = "'" + (String)converterExpression + "'";
            }
            catch (Exception e) {
                logger.warn("Cannot load converter class " + e.getMessage());
                converterExpression = null;
            }
        }
        binder.addPropertyLoadBindings(component, bindingAttribute, expression, null, null, null, (String)converterExpression, null);
        if (!(component instanceof Label || component instanceof Image || component instanceof CoolLabel)) {
            binder.addPropertySaveBindings(component, bindingAttribute, expression, null, saveAfterCmds, null, (String)converterExpression, null, null, null);
        }
    }

    public static void postNotifyChange(Object viewmodel) {
        ZKBindingUtil.postNotifyChange(viewmodel, "*");
    }

    public static void postNotifyChange(Object viewmodel, String property) {
        if (ZKUtil.isInEventListener()) {
            BindUtils.postNotifyChange(null, null, (Object)viewmodel, (String)property);
        }
    }

    public static void postNotifyChange(Object viewmodel, String ... properties) {
        if (properties != null) {
            Stream.of(properties).forEach(p -> ZKBindingUtil.postNotifyChange(viewmodel, p));
        }
    }

    public static void postNotifyChange(String queue, String scope, Object viewmodel, String property) {
        BindUtils.postNotifyChange((String)queue, (String)scope, (Object)viewmodel, (String)property);
    }

    public static void postGlobalCommand(String name) {
        ZKBindingUtil.postGlobalCommand(name, null);
    }

    public static void postGlobalCommand(String name, Map<String, Object> args) {
        BindUtils.postGlobalCommand(null, null, (String)name, args);
    }

    private ZKBindingUtil() {
    }
}

