/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.zkoss.zhtml.impl.AbstractTag;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Bandbox;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Include;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.InputElement;
import org.zkoss.zul.impl.LabelImageElement;
import tools.dynamia.commons.MapBuilder;
import tools.dynamia.commons.StringUtils;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.domain.query.DataPaginator;
import tools.dynamia.domain.util.DomainUtils;
import tools.dynamia.integration.Containers;
import tools.dynamia.io.IOUtils;
import tools.dynamia.io.Resource;
import tools.dynamia.navigation.Page;
import tools.dynamia.ui.MessageDisplayer;
import tools.dynamia.ui.MessageType;
import tools.dynamia.ui.icons.Icon;
import tools.dynamia.ui.icons.IconSize;
import tools.dynamia.ui.icons.IconType;
import tools.dynamia.ui.icons.IconsTheme;
import tools.dynamia.web.util.HttpUtils;
import tools.dynamia.zk.EventQueueSubscriber;
import tools.dynamia.zk.navigation.ZKNavigationManager;
import tools.dynamia.zk.ui.CanBeReadonly;
import tools.dynamia.zk.ui.InputPanel;
import tools.dynamia.zk.ui.MessageDialog;

public abstract class ZKUtil {
    private static final LoggingService LOGGER = new SLF4JLoggingService(ZKUtil.class);
    private static final String PARENT_WINDOW = "parentWindow";
    private static final String ENTITY = "entity";
    public static final String NAVIGATION_PAGE = "navigationPage";
    public static final int YES = 16;
    public static final int NO = 32;

    private ZKUtil() {
    }

    public static void showMessage(String message) {
        ZKUtil.showMessage(message, "Mensaje", MessageType.NORMAL);
    }

    public static void showMessage(String message, MessageType type) {
        ZKUtil.showMessage(message, "Message", type);
    }

    public static void showMessage(String message, String title, MessageType type) {
        MessageDisplayer displayer = (MessageDisplayer)Containers.get().findObject(MessageDisplayer.class);
        if (displayer == null) {
            displayer = new MessageDialog();
        }
        displayer.showMessage(message, title, type);
    }

    public static void showQuestion(String question, String title, EventListener<Messagebox.ClickEvent> listener) {
        Messagebox.Button[] buttons = new Messagebox.Button[]{Messagebox.Button.YES, Messagebox.Button.NO};
        Messagebox.show((String)question, (String)title, (Messagebox.Button[])buttons, (String)"z-messagebox-icon z-messagebox-question", listener);
    }

    public static void fillCombobox(Combobox combo, Collection data, boolean live) {
        ZKUtil.fillCombobox(combo, data, null, live);
    }

    public static void fillCombobox(Combobox combo, Collection data, Object selected, boolean live) {
        if (combo != null) {
            ListModelList model = new ListModelList(data);
            if (selected != null) {
                model.addToSelection(selected);
            }
            combo.setModel((ListModel)model);
        }
    }

    public static void fillCombobox(Combobox combo, List data) {
        ZKUtil.fillCombobox(combo, data, true);
    }

    public static void fillCombobox(Combobox combo, List data, boolean live) {
        ZKUtil.fillCombobox(combo, data, null, live);
    }

    public static void fillCombobox(Combobox combo, Object[] data, boolean live) {
        if (combo != null) {
            List<Object> dataList = Arrays.asList(data);
            ZKUtil.fillCombobox(combo, dataList, live);
        }
    }

    public static void fillListbox(Listbox listbox, Collection data, boolean live) {
        if (listbox != null && data != null) {
            listbox.setModel((ListModel)null);
            if (data instanceof List) {
                listbox.setModel((ListModel)new ListModelList((List)data, live));
            } else {
                listbox.setModel((ListModel)new ListModelList(new ArrayList(data), live));
            }
        }
    }

    public static void fillListbox(Listbox listbox, List data, boolean live) {
        if (listbox != null && data != null) {
            listbox.setModel((ListModel)null);
            listbox.setModel((ListModel)new ListModelList(data, live));
        }
    }

    public static void fillListbox(Listbox listbox, Object[] data, boolean live) {
        if (listbox != null && data != null) {
            List<Object> dataList = Arrays.asList(data);
            ZKUtil.fillListbox(listbox, dataList, live);
        }
    }

    public static void clearPage(org.zkoss.zk.ui.Page page) {
        if (page != null) {
            Component comp = page.getFirstRoot();
            ZKUtil.clearComponent(comp);
        }
    }

    public static void clearComponent(Component comp) {
        for (Object object : comp.getChildren()) {
            try {
                ZKUtil.clearComponent((Component)object);
            }
            catch (Exception exception) {}
        }
        if (comp instanceof InputElement) {
            InputElement ie = (InputElement)comp;
            ie.setRawValue(null);
        }
    }

    public static Window showDialog(String uri, String title, Object data, String width, String height) {
        return ZKUtil.showDialog(uri, title, data, width, height, null);
    }

    public static Window showDialog(String uri, String title, String width, String height) {
        return ZKUtil.showDialog(uri, title, null, width, height, null);
    }

    public static Window showDialog(String uri, String title, Object data, String width, String height, EventListener onCloseListener) {
        Window dialog = ZKUtil.createWindow(uri, title, data);
        if (onCloseListener != null) {
            dialog.addEventListener("onClose", onCloseListener);
        }
        if (height != null) {
            dialog.setHeight(height);
        }
        if (width != null) {
            dialog.setWidth(width);
        }
        if (HttpUtils.isSmartphone()) {
            dialog.setWidth("99%");
            dialog.setHeight("99%");
            dialog.setDraggable("false");
        }
        dialog.doModal();
        return dialog;
    }

    public static Window createWindow(String uri, String title, Object data) {
        Window dialog = new Window();
        Caption caption = new Caption(title);
        caption.setIconSclass("fa fa-dot-circle");
        dialog.appendChild((Component)caption);
        dialog.setClosable(true);
        dialog.setBorder("normal");
        dialog.setPage(ZKUtil.getFirstPage());
        if (uri != null) {
            Map args = MapBuilder.put((Object[])new Object[]{"dialog", dialog, "result", data, "data", data});
            if (data instanceof Map) {
                Map map = (Map)data;
                for (Object key : map.keySet()) {
                    args.put(key.toString(), map.get(key));
                }
            }
            if (DomainUtils.isEntity((Object)data)) {
                args.put(ENTITY, data);
            }
            args.put(PARENT_WINDOW, dialog);
            Component component = ZKUtil.createComponent(uri, (Component)dialog, args);
            if (component instanceof Include) {
                ((Include)component).setVflex("1");
            }
        }
        dialog.addEventListener("onCancel", e -> {
            if (dialog.isClosable()) {
                dialog.detach();
            }
        });
        return dialog;
    }

    public static Window createWindow(String title) {
        return ZKUtil.createWindow(null, title, null);
    }

    public static Window showDialog(String uri, String title, Object data) {
        return ZKUtil.showDialog(uri, title, data, null, null);
    }

    public static Window showDialog(String uri, String title) {
        return ZKUtil.showDialog(uri, title, null, null, null);
    }

    public static Window showDialog(String title, Component component) {
        return ZKUtil.showDialog(title, component, null, null);
    }

    public static Window showDialog(String title, Component component, String width, String height) {
        return ZKUtil.showDialog(title, component, width, height, null);
    }

    public static Window showDialog(String title, Component component, String width, String height, EventListener<Event> onCloseListener) {
        try {
            HtmlBasedComponent hcomp;
            Window dialog = ZKUtil.createWindow(title);
            dialog.setMaximizable(true);
            if (onCloseListener != null) {
                dialog.addEventListener("onClose", onCloseListener);
            }
            dialog.setWidth("80%");
            if (width != null) {
                dialog.setWidth(width);
            }
            if (height != null) {
                dialog.setHeight(height);
            }
            if (HttpUtils.isSmartphone()) {
                dialog.setWidth("99%");
                dialog.setHeight("99%");
                dialog.setDraggable("false");
            }
            component.setParent((Component)dialog);
            if (component instanceof HtmlBasedComponent && height != null && (hcomp = (HtmlBasedComponent)component).getVflex() == null) {
                hcomp.setVflex("1");
            }
            dialog.doModal();
            return dialog;
        }
        catch (Exception ex) {
            LOGGER.error("Error showing Window dialog", (Throwable)ex);
            return null;
        }
    }

    public static <T> InputPanel showInputDialog(String label, Class<T> inputClass, Object value, EventListener eventListener) {
        InputPanel inputPanel = new InputPanel(label, value, inputClass);
        inputPanel.addEventListener("onInput", eventListener);
        inputPanel.showDialog();
        return inputPanel;
    }

    public static <T> InputPanel showInputDialog(String label, Class<T> inputClass, EventListener eventListener) {
        return ZKUtil.showInputDialog(label, inputClass, null, eventListener);
    }

    public static boolean isEmpty(InputElement input) {
        return input.getText() == null || input.getText().isEmpty();
    }

    public static void synchronizePaginator(DataPaginator dataPaginator, Paginal paginal) {
        if (dataPaginator != null && paginal != null) {
            dataPaginator.setPage(paginal.getActivePage() + 1);
            dataPaginator.setPageSize(paginal.getPageSize());
            paginal.setTotalSize((int)dataPaginator.getTotalSize());
        }
    }

    public static org.zkoss.zk.ui.Page getFirstPage() {
        Desktop desktop = Executions.getCurrent().getDesktop();
        return desktop.getFirstPage();
    }

    public static Popup showPopup(Component refComponent, Component contentComponent, String width, String height) {
        Popup popup = new Popup();
        popup.setPage(refComponent.getPage());
        if (width != null) {
            popup.setWidth(width);
        }
        if (height != null) {
            popup.setHeight(height);
        }
        contentComponent.setParent((Component)popup);
        popup.open(refComponent);
        return popup;
    }

    public static Popup showPopup(Component refComponent, Component contentComponent) {
        return ZKUtil.showPopup(refComponent, contentComponent, null, null);
    }

    public static String getSessionID() {
        HttpSession session = (HttpSession)Executions.getCurrent().getSession().getNativeSession();
        return session.getId();
    }

    public static Component createAjaxLoader(String message, String imagePath) {
        Vbox div = new Vbox();
        div.setWidth("100%");
        div.setHeight("100%");
        div.setPack("center");
        div.setAlign("center");
        div.setSclass("ajax-loader");
        Vbox box = new Vbox();
        box.setPack("center");
        box.setAlign("center");
        div.appendChild((Component)box);
        if (imagePath == null) {
            imagePath = "/zkau/web/tools/images/ajax-loader.gif";
        }
        Image img = new Image(imagePath);
        Label lbl = new Label(message);
        lbl.setStyle("font-weight:bold");
        box.appendChild((Component)img);
        box.appendChild((Component)lbl);
        return div;
    }

    public static Component createAjaxLoader() {
        return ZKUtil.createAjaxLoader("", null);
    }

    public static Component createAjaxLoader(String message) {
        return ZKUtil.createAjaxLoader(message, null);
    }

    public static Popup createTooltip(String title, String description) {
        Popup popup = new Popup();
        Vlayout layout = new Vlayout();
        popup.appendChild((Component)layout);
        Label lbltitle = new Label(title);
        layout.appendChild((Component)lbltitle);
        if (description != null && !description.isEmpty()) {
            layout.appendChild((Component)new Label(description));
            lbltitle.setStyle("font-weight:bold");
        }
        return popup;
    }

    public static Popup createTooltip(String text) {
        return ZKUtil.createTooltip(text, null);
    }

    public static void configureComponentIcon(Icon icon, Component component, IconSize size) {
        if (icon == null) {
            return;
        }
        String realPath = icon.getRealPath((Object)component, size);
        if (component instanceof LabelImageElement) {
            LabelImageElement element = (LabelImageElement)component;
            switch (icon.getType()) {
                case IMAGE: {
                    element.setImage(realPath);
                    break;
                }
                case FONT: {
                    element.setIconSclass(realPath);
                }
            }
        } else if (component instanceof AbstractTag) {
            AbstractTag element = (AbstractTag)component;
            switch (icon.getType()) {
                case IMAGE: {
                    Image img = new Image(realPath);
                    img.setParent(component);
                    break;
                }
                case FONT: {
                    element.setSclass(realPath);
                }
            }
        } else if (component instanceof Image && icon.getType() == IconType.IMAGE) {
            Image image = (Image)component;
            image.setSrc(realPath);
        }
    }

    public static void configureComponentIcon(String image, Component component, IconSize size) {
        ZKUtil.configureComponentIcon(IconsTheme.get().getIcon(image), component, size);
    }

    public static Component createComponent(String uri, Component parent, Map<?, ?> args) {
        if (ZKUtil.isResourceURI(uri)) {
            Resource resource = ZKUtil.getDeviceResource(uri);
            if (resource == null) {
                throw new UiException("Resource for page not found " + uri);
            }
            try {
                if (resource.exists()) {
                    return Executions.createComponentsDirectly((Reader)new InputStreamReader(resource.getInputStream()), (String)resource.getFileExtension(), (Component)parent, args);
                }
                throw new UiException("Resource for page not exists " + uri);
            }
            catch (IOException e) {
                throw new UiException("Error creating component directly from resource" + resource, (Throwable)e);
            }
        }
        Include include = new Include(uri);
        include.setParent(parent);
        if (args != null) {
            for (Object key : args.keySet()) {
                include.setAttribute(key.toString(), args.get(key));
            }
        }
        return include;
    }

    private static Resource getDeviceResource(String uri) {
        Resource resource = null;
        String device = HttpUtils.detectDevice();
        String deviceUri = uri;
        if (!"screen".equals(device)) {
            String ext = "." + StringUtils.getFilenameExtension((String)uri);
            if (deviceUri.endsWith(ext)) {
                deviceUri = deviceUri.replace(ext, "." + device.toLowerCase() + ext);
            }
            if ((resource = IOUtils.getResource((String)deviceUri)) == null || !resource.exists()) {
                deviceUri = uri;
                resource = null;
            }
        }
        if (resource == null) {
            resource = IOUtils.getResource((String)deviceUri);
        }
        return resource;
    }

    private static boolean isResourceURI(String uri) {
        return uri.startsWith("classpath:") || uri.startsWith("file:") || uri.startsWith("http:");
    }

    public static void initEventQueueSubscribers(Object target) {
        new EventQueueSubscriber(target).loadAnnotations();
    }

    public static void eventQueuePublish(String name, String scope, boolean autocreate, Event evt) {
        EventQueues.lookup((String)name, (String)scope, (boolean)autocreate).publish(evt);
    }

    public static void eventQueuePublish(String name, Event evt) {
        ZKUtil.eventQueuePublish(name, "desktop", true, evt);
    }

    public static boolean isInEventListener() {
        return Executions.getCurrent() != null;
    }

    public static Window showListboxSelector(String title, List model, EventListener<SelectEvent> onSelect) {
        Listbox listbox = new Listbox();
        listbox.setVflex("1");
        listbox.setHflex("1");
        ZKUtil.fillListbox(listbox, model, true);
        Window win = ZKUtil.showDialog(title, (Component)listbox, "500px", "500px");
        listbox.addEventListener("onSelect", evt -> {
            win.detach();
            onSelect.onEvent(evt);
        });
        return win;
    }

    public static Window showListboxMultiSelector(String title, String label, List model, EventListener<Event> onSelect) {
        Listbox listbox = new Listbox();
        listbox.setVflex("1");
        listbox.setWidth("100%");
        listbox.setCheckmark(true);
        ZKUtil.fillListbox(listbox, model, true);
        listbox.setMultiple(true);
        Window win = ZKUtil.showDialog(title, (Component)listbox, "500px", "500px");
        Button btn = new Button(label);
        win.appendChild((Component)btn);
        btn.addEventListener("onClick", evt -> {
            win.detach();
            if (listbox.getSelectedCount() > 0) {
                List selectedObjects = listbox.getSelectedItems().stream().map(Listitem::getValue).collect(Collectors.toList());
                onSelect.onEvent(new Event("onSelect", (Component)listbox, selectedObjects));
            }
        });
        return win;
    }

    public static void showTextInputDialog(String title, String buttonLabel, EventListener<Event> evt) {
        Vlayout vlayout = new Vlayout();
        Textbox textbox = new Textbox();
        textbox.setMultiline(true);
        textbox.setWidth("100%");
        textbox.setHeight("100px");
        vlayout.appendChild((Component)textbox);
        Button btn = new Button(buttonLabel);
        btn.setAutodisable("self");
        btn.setStyle("float: right");
        vlayout.appendChild((Component)btn);
        Window win = ZKUtil.showDialog(title, (Component)vlayout);
        win.setWidth("500px");
        btn.addEventListener("onClick", e -> {
            Event newEvt = new Event("onClick", (Component)vlayout, (Object)textbox.getValue());
            evt.onEvent(newEvt);
            if (newEvt.isPropagatable()) {
                win.detach();
            }
        });
    }

    public static void setSelected(Combobox combobox, Object value) {
        if (combobox != null) {
            if (value == null) {
                combobox.setSelectedItem(null);
            } else if (combobox.getModel() instanceof ListModelList) {
                ((ListModelList)combobox.getModel()).addToSelection(value);
            }
        }
    }

    public static void setSelected(Listbox listbox, Object value) {
        if (listbox != null) {
            if (value == null) {
                listbox.setSelectedItem(null);
            } else if (listbox.getModel() instanceof ListModelList) {
                ((ListModelList)listbox.getModel()).addToSelection(value);
            }
        }
    }

    public static Object getExecutionArg(String name) {
        return Executions.getCurrent().getArg().get(name);
    }

    public static Object getExecutionEntity() {
        return ZKUtil.getExecutionArg(ENTITY);
    }

    public static Window getExecutionParentWindow() {
        return (Window)ZKUtil.getExecutionArg(PARENT_WINDOW);
    }

    public static Page getExecutionNavigationPage() {
        Page page = (Page)ZKUtil.getExecutionArg(NAVIGATION_PAGE);
        if (page == null) {
            page = ZKNavigationManager.getInstance().getCurrentPage();
        }
        return page;
    }

    public static void changeReadOnly(Component comp, boolean readOnly) {
        if (comp instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)comp;
            checkbox.setDisabled(readOnly);
        }
        if (comp instanceof InputElement) {
            InputElement input = (InputElement)comp;
            input.setReadonly(readOnly);
        }
        if (comp instanceof CanBeReadonly) {
            ((CanBeReadonly)comp).setReadonly(readOnly);
        }
        if (comp instanceof Button) {
            Button button = (Button)comp;
            button.setDisabled(readOnly);
        }
        if (comp instanceof Datebox) {
            Datebox datebox = (Datebox)comp;
            datebox.setButtonVisible(!readOnly);
        } else if (comp instanceof Combobox) {
            Combobox combo = (Combobox)comp;
            combo.setButtonVisible(!readOnly);
        } else if (comp instanceof Bandbox) {
            Bandbox bandbox = (Bandbox)comp;
            bandbox.setReadonly(readOnly);
        }
        if (comp != null && comp.getChildren() != null && !comp.getChildren().isEmpty()) {
            for (Component child : comp.getChildren()) {
                ZKUtil.changeReadOnly(child, readOnly);
            }
        }
    }

    public static Window showDialog(String uri, String title, String icon, Object data, String width, String height, EventListener onCloseListener) {
        Window window = ZKUtil.showDialog(uri, title, data, width, height, onCloseListener);
        if (window.getCaption() != null) {
            window.getCaption().setIconSclass(icon);
        }
        return window;
    }

    public static void updateClientURI(String pagetitle, String uri) {
        Clients.evalJavaScript((String)String.format("changeURI('%s','%s');", pagetitle, uri));
    }
}

