/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.websocket;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.zk.websocket.WebSocketGlobalCommandHandler;

@Configuration
@EnableWebSocket
public class WebSocketGlobalCommandConfig
implements WebSocketConfigurer {
    private final LoggingService logger = new SLF4JLoggingService(WebSocketGlobalCommandConfig.class);

    public WebSocketGlobalCommandConfig() {
        this.logger.info("Starting " + this.getClass());
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        this.logger.info("Registering WS Handler for ZK Commands");
        registry.addHandler(this.globalCommandHandler(), new String[]{"/ws-commands"}).withSockJS();
    }

    @Bean
    public WebSocketHandler globalCommandHandler() {
        return new WebSocketGlobalCommandHandler();
    }
}

