/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.websocket;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.zkoss.zk.ui.Desktop;

public class WebSocketGlobalCommandHandler
extends TextWebSocketHandler {
    private final Map<String, String> desktops = new ConcurrentHashMap<String, String>();
    private final Map<String, WebSocketSession> sessions = new ConcurrentHashMap<String, WebSocketSession>();

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        WebSocketSession oldSession;
        String desktopId = (String)message.getPayload();
        String oldSessionId = this.desktops.get(desktopId);
        if (oldSessionId != null && (oldSession = this.sessions.get(oldSessionId)) != null) {
            oldSession.close(CloseStatus.NORMAL);
        }
        this.desktops.put(desktopId, session.getId());
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.sessions.put(session.getId(), session);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        String desktopId = this.desktops.entrySet().stream().filter(e -> ((String)e.getValue()).equals(session.getId())).map(Map.Entry::getKey).findFirst().orElse(null);
        if (desktopId != null) {
            this.desktops.remove(desktopId);
        }
        this.sessions.remove(session.getId());
    }

    WebSocketSession findSession(Desktop desktop) {
        String sessionID;
        WebSocketSession session = null;
        if (desktop != null && desktop.getId() != null && (sessionID = this.desktops.get(desktop.getId())) != null) {
            session = this.sessions.get(sessionID);
        }
        return session;
    }

    Collection<WebSocketSession> getAllSessions() {
        return this.sessions.values();
    }
}

