/*
 * Decompiled with CFR 0.152.
 */
package tools.dynamia.zk.websocket;

import java.io.IOException;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.util.Clients;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.integration.Containers;
import tools.dynamia.zk.util.ZKUtil;
import tools.dynamia.zk.websocket.WebSocketGlobalCommandHandler;

public abstract class WebSocketPushSender {
    private static final LoggingService LOGGER = new SLF4JLoggingService(WebSocketPushSender.class);

    public static boolean sendPushCommand(Desktop desktop, String command) {
        WebSocketGlobalCommandHandler handler = (WebSocketGlobalCommandHandler)((Object)Containers.get().findObject(WebSocketGlobalCommandHandler.class));
        if (handler != null) {
            try {
                WebSocketSession session = handler.findSession(desktop);
                if (session != null) {
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)command));
                    return true;
                }
                LOGGER.warn("No websocket session found for desktop " + desktop);
            }
            catch (Exception e) {
                LOGGER.error("Error sending push command '" + command + "' to Dekstop: " + desktop, (Throwable)e);
            }
        } else {
            LOGGER.warn("No websocket handler found");
        }
        return false;
    }

    public static boolean sendPushCommand(String command) {
        return WebSocketPushSender.sendPushCommand(Executions.getCurrent().getDesktop(), command);
    }

    public static void broadcastCommand(String command) {
        WebSocketGlobalCommandHandler handler = (WebSocketGlobalCommandHandler)((Object)Containers.get().findObject(WebSocketGlobalCommandHandler.class));
        if (handler != null) {
            handler.getAllSessions().forEach(s -> {
                try {
                    s.sendMessage((WebSocketMessage)new TextMessage((CharSequence)command));
                }
                catch (IOException e) {
                    LOGGER.error("Error sending command " + command + " to WS Session: " + s);
                }
            });
        }
    }

    public static void initWS() {
        if (ZKUtil.isInEventListener()) {
            try {
                Clients.evalJavaScript((String)"initWebSocket('/ws-commands');");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

