/*
 * Decompiled with CFR 0.152.
 */
package workspace.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;
import tools.dynamia.commons.Messages;
import tools.dynamia.commons.logger.LoggingService;
import tools.dynamia.commons.logger.SLF4JLoggingService;
import tools.dynamia.navigation.NavigationManager;
import tools.dynamia.navigation.Page;
import tools.dynamia.ui.icons.IconSize;
import tools.dynamia.ui.icons.IconsTheme;
import tools.dynamia.zk.AbstractZKWorkspaceBuilder;
import tools.dynamia.zk.navigation.ZKNavigationManager;
import tools.dynamia.zk.util.ZKUtil;

public class TabPanel
extends AbstractZKWorkspaceBuilder {
    private final LoggingService logger = new SLF4JLoggingService();
    private static final String TAB_PAGE = "tab-page";
    private final transient Tabbox tabbox;
    private final Locale locale = Messages.getDefaultLocale();

    public TabPanel() {
        this.tabbox = new Tabbox();
        this.tabbox.setHeight("100%");
        this.tabbox.setWidth("100%");
        new Tabs().setParent((Component)this.tabbox);
        new Tabpanels().setParent((Component)this.tabbox);
        this.createToolbar();
        this.tabbox.addEventListener("onSelect", event -> {
            Page page = (Page)this.tabbox.getSelectedTab().getAttributes().get(TAB_PAGE);
            if (page != null) {
                NavigationManager.getCurrent().setCurrentPage(page);
            }
        });
    }

    @Override
    public void init(Component container) {
        super.init(container);
        this.tabbox.setParent(container);
    }

    private void createToolbar() {
        Toolbar toolbar = new Toolbar();
        toolbar.setParent((Component)this.tabbox);
        IconsTheme iconsTheme = IconsTheme.get();
        Toolbarbutton btn = new Toolbarbutton();
        btn.setParent((Component)toolbar);
        btn.setTooltiptext(Messages.get(TabPanel.class, (String)"tabRefresh"));
        btn.addEventListener("onClick", event -> this.refreshSelectedPage());
        ZKUtil.configureComponentIcon(iconsTheme.getIcon("view-refresh"), (Component)btn, IconSize.NORMAL);
        btn = new Toolbarbutton();
        btn.setParent((Component)toolbar);
        btn.setSclass("hidden-xs");
        btn.setTooltiptext(Messages.get(TabPanel.class, (String)"tabCloseOthers"));
        btn.addEventListener("onClick", event -> this.closeAllPagesButSelected());
        ZKUtil.configureComponentIcon(iconsTheme.getIcon("window-close"), (Component)btn, IconSize.NORMAL);
        btn = new Toolbarbutton();
        btn.setParent((Component)toolbar);
        btn.setSclass("hidden-xs");
        btn.setTooltiptext(Messages.get(TabPanel.class, (String)"tabCloseAll"));
        btn.addEventListener("onClick", event -> this.closeAllPages());
        ZKUtil.configureComponentIcon(iconsTheme.getIcon("window-close-all"), (Component)btn, IconSize.NORMAL);
    }

    public void build(Page page) {
        this.update(page, null);
    }

    @Override
    public void update(Page page, Map<String, Object> params) {
        if (page != null && page.isShowAsPopup()) {
            super.update(page, params);
        } else if (this.tabbox != null && page != null) {
            Tab tab = this.getTab(page);
            if (tab == null) {
                super.update(page, params);
            } else {
                this.tabbox.setSelectedTab(tab);
                ZKNavigationManager.getInstance().setRawCurrentPage(page);
            }
        }
    }

    @Override
    public void clearPageContainer(Component pageContainer) {
        if (pageContainer instanceof Tabpanel) {
            pageContainer.getChildren().clear();
        }
    }

    @Override
    public Component getPageContainer(Page page) {
        if (page.isShowAsPopup()) {
            return this.container;
        }
        Tab tab = new Tab(page.getLocalizedName(this.locale));
        if (page.getLongName() != null) {
            tab.setLabel(page.getLongName());
        } else if (page.getLongNameSupplier() != null) {
            tab.setLabel((String)page.getLongNameSupplier().get());
        }
        tab.getAttributes().put(TAB_PAGE, page);
        tab.setClosable(page.isClosable());
        ZKUtil.configureComponentIcon(page.getIcon(), (Component)tab, IconSize.SMALL);
        tab.setSclass("tabpage");
        tab.addSclass(page.getId());
        tab.setTooltiptext(page.getLocalizedDescription(this.locale));
        Tabpanel panel = new Tabpanel();
        panel.setRenderdefer(100);
        panel.setSclass(page.getId());
        this.tabbox.getTabs().appendChild((Component)tab);
        this.tabbox.getTabpanels().appendChild((Component)panel);
        return panel;
    }

    @Override
    protected void postUpdate(Component pageComponent, Page page, Map<String, Object> params) {
        if (pageComponent.getParent() instanceof Tabpanel) {
            Tabpanel tabpanel = (Tabpanel)pageComponent.getParent();
            Tab tab = tabpanel.getLinkedTab();
            if (params != null) {
                if (params.get("PAGE_TITLE") != null) {
                    tab.setLabel(params.get("PAGE_TITLE").toString());
                }
                if (params.get("NEW_PAGE") == Boolean.TRUE) {
                    tab.getAttributes().remove(TAB_PAGE);
                }
            }
            if (page.getAttribute("title") != null) {
                tab.setLabel((String)page.getAttribute("title"));
            }
            this.tabbox.setSelectedTab(tab);
        }
    }

    private Tab getTab(Page page) {
        for (Object object : this.tabbox.getTabs().getChildren()) {
            Tab tab = (Tab)object;
            if (!tab.getAttributes().containsKey(TAB_PAGE)) continue;
            Page pageTab = (Page)tab.getAttribute(TAB_PAGE);
            if (!page.getVirtualPath().equals(pageTab.getVirtualPath())) continue;
            return tab;
        }
        return null;
    }

    public void closeAllPages() {
        try {
            if (this.tabbox != null) {
                ArrayList<Tab> toClose = new ArrayList<Tab>();
                for (Object object : this.tabbox.getTabs().getChildren()) {
                    Tab tab = (Tab)object;
                    if (!tab.isClosable()) continue;
                    toClose.add(tab);
                }
                this.closeTabs(toClose);
            }
        }
        catch (Exception e) {
            this.logger.error("Error closing all Pages", (Throwable)e);
        }
    }

    public void closeAllPagesButSelected() {
        try {
            if (this.tabbox != null) {
                ArrayList<Tab> toClose = new ArrayList<Tab>();
                for (Object object : this.tabbox.getTabs().getChildren()) {
                    Tab tab = (Tab)object;
                    if (!tab.isClosable() || tab.isSelected()) continue;
                    toClose.add(tab);
                }
                this.closeTabs(toClose);
            }
        }
        catch (Exception e) {
            this.logger.error("Error closing all Pages but selected", (Throwable)e);
        }
    }

    private void closeTabs(List<Tab> tabs) {
        if (tabs != null) {
            for (Tab tab : tabs) {
                tab.onClose();
            }
        }
    }

    private void refreshSelectedPage() {
        Tab tab = this.tabbox.getSelectedTab();
        if (tab != null) {
            Page page = (Page)tab.getAttribute(TAB_PAGE);
            Tabpanel panel = tab.getLinkedPanel();
            if (page != null && panel != null) {
                panel.getChildren().clear();
                this.renderPage((Component)panel, page, null);
            }
        }
    }

    @Override
    public void close(Page page) {
        if (page != null) {
            Tab tab;
            if (page.isShowAsPopup() && this.currentWindow != null) {
                this.currentWindow.detach();
                this.currentWindow = null;
            } else if (!page.isShowAsPopup() && (tab = this.getTab(page)) != null) {
                tab.close();
            }
        }
    }
}

