/*
 * Copyright (C) 2023 Dynamia Soluciones IT S.A.S - NIT 900302344-1
 * Colombia / South America
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package tools.dynamia.zk.crud;

import org.springframework.stereotype.Component;
import tools.dynamia.crud.ChangedStateEvent;
import tools.dynamia.crud.CrudState;
import tools.dynamia.crud.CrudStateChangedListener;
import tools.dynamia.crud.GenericCrudView;
import tools.dynamia.viewers.util.Viewers;

@Component
public class AutoQueryCrudStateChangedListener implements CrudStateChangedListener {

    @Override
    public void changedState(ChangedStateEvent evt) {
        GenericCrudView crudView = evt.crudView();
        if (evt.newState() == CrudState.READ) {
            try {

                if (crudView.getViewDescriptor().getParams().get(Viewers.PARAM_AUTOQUERY) != Boolean.FALSE
                        && crudView.getController().isQueryResultEmpty()) {
                    crudView.getController().doQuery();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            crudView.getController().clear();
        }
    }

}
