/*
 * Decompiled with CFR 0.152.
 */
package tools.kaja.pegdown;

import org.apache.commons.lang3.StringUtils;

public class RstWriter {
    protected static final String NEW_LINE = "\n";
    protected static final int INDENT_SPACES = 4;
    protected String rst;
    protected int indent;
    protected int lastLineLength;
    protected boolean rawInlineHtmlEnabled;

    public RstWriter() {
        this.clear();
    }

    public void clear() {
        this.rst = "";
        this.indent = 0;
        this.lastLineLength = 0;
        this.rawInlineHtmlEnabled = false;
    }

    public void text(String text) {
        this.markup(this.escape(text));
    }

    public void markup(String text) {
        this.markup(text, this.rst.isEmpty() || this.rst.endsWith(NEW_LINE));
    }

    public void newLine() {
        this.rst = this.rst + NEW_LINE;
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    public int getLastLineLength() {
        return this.lastLineLength;
    }

    public void enableRawInlineHtml() {
        this.rawInlineHtmlEnabled = true;
    }

    public String toString() {
        String output = "";
        if (this.rawInlineHtmlEnabled) {
            output = output + ".. role:: raw-html(raw)\n";
            output = output + "    :format: html\n";
            output = output + NEW_LINE;
        }
        output = output + this.rst.replaceAll("\\s+$", "");
        return output;
    }

    protected void markup(String text, boolean useIdent) {
        if (useIdent) {
            text = text.replaceAll("^\\s", "");
        }
        int spaces = useIdent ? this.indent * 4 : 0;
        String[] lines = text.split(NEW_LINE);
        for (int i = 0; i < lines.length; ++i) {
            this.rst = this.rst + StringUtils.repeat((String)" ", (int)spaces) + lines[i];
            if (i >= lines.length - 1) continue;
            this.newLine();
        }
        this.lastLineLength = lines[lines.length - 1].length();
    }

    protected String escape(String text) {
        return text.replaceAll("([`\\|*_])", "\\\\$1");
    }
}

