/*
 * Decompiled with CFR 0.152.
 */
package tools.kaja.pegdown;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.parboiled.common.Preconditions;
import org.pegdown.ast.AbbreviationNode;
import org.pegdown.ast.AbstractNode;
import org.pegdown.ast.AnchorLinkNode;
import org.pegdown.ast.AutoLinkNode;
import org.pegdown.ast.BlockQuoteNode;
import org.pegdown.ast.BulletListNode;
import org.pegdown.ast.CodeNode;
import org.pegdown.ast.DefinitionListNode;
import org.pegdown.ast.DefinitionNode;
import org.pegdown.ast.DefinitionTermNode;
import org.pegdown.ast.ExpImageNode;
import org.pegdown.ast.ExpLinkNode;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.InlineHtmlNode;
import org.pegdown.ast.ListItemNode;
import org.pegdown.ast.MailLinkNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.OrderedListNode;
import org.pegdown.ast.ParaNode;
import org.pegdown.ast.QuotedNode;
import org.pegdown.ast.RefImageNode;
import org.pegdown.ast.RefLinkNode;
import org.pegdown.ast.ReferenceNode;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SimpleNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.StrikeNode;
import org.pegdown.ast.StrongEmphSuperNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TableBodyNode;
import org.pegdown.ast.TableCaptionNode;
import org.pegdown.ast.TableCellNode;
import org.pegdown.ast.TableColumnNode;
import org.pegdown.ast.TableHeaderNode;
import org.pegdown.ast.TableNode;
import org.pegdown.ast.TableRowNode;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.VerbatimNode;
import org.pegdown.ast.Visitor;
import org.pegdown.ast.WikiLinkNode;
import tools.kaja.pegdown.RstWriter;
import tools.kaja.pegdown.table.Cell;
import tools.kaja.pegdown.table.RowType;
import tools.kaja.pegdown.table.Table;
import tools.kaja.pegdown.table.TableRstWriter;

public class ToRstSerializer
implements Visitor {
    protected static final String[] DEFAULT_HEADERS = new String[]{"#", "*", "=", "-", "^", "\""};
    protected String[] headers;
    protected RstWriter rstWriter;
    protected Map<String, RstWriter> rstWriters;
    protected Table table;
    protected TableRstWriter tableRstWriter;
    protected Map<String, ExpImageNode> images;
    protected List<String> unsupported;
    protected String listItemMarker;

    public ToRstSerializer(String[] headers) {
        this.headers = headers;
        this.rstWriters = new HashMap<String, RstWriter>();
        this.rstWriters.put("main", new RstWriter());
        this.rstWriters.put("tableCell", new RstWriter());
        this.setRstWriter("main");
        this.tableRstWriter = new TableRstWriter(this.rstWriter);
    }

    public ToRstSerializer() {
        this(DEFAULT_HEADERS);
    }

    public String toRst(RootNode astRoot, char[] md) {
        Preconditions.checkArgNotNull((Object)astRoot, (String)"astRoot");
        this.images = new TreeMap<String, ExpImageNode>();
        this.unsupported = new ArrayList<String>();
        astRoot.accept((Visitor)this);
        this.writeImages();
        this.writeUnsupported();
        String rst = this.rstWriter.toString();
        this.rstWriter.clear();
        this.unsupported = null;
        this.images = null;
        return rst;
    }

    public void visit(AbbreviationNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(AnchorLinkNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(AutoLinkNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(BlockQuoteNode node) {
        this.rstWriter.indent();
        this.visitChildren((SuperNode)node);
        this.rstWriter.outdent();
        this.rstWriter.markup("..");
        this.rstWriter.newLine();
        this.rstWriter.newLine();
    }

    public void visit(BulletListNode node) {
        this.listItemMarker = "*";
        this.visitChildren((SuperNode)node);
        this.rstWriter.newLine();
    }

    public void visit(CodeNode node) {
        this.rstWriter.markup("``");
        this.rstWriter.text(node.getText());
        this.rstWriter.markup("``");
    }

    public void visit(DefinitionListNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(DefinitionNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(DefinitionTermNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(ExpImageNode node) {
        String id = this.image(node);
        this.rstWriter.markup("|" + id + "|");
    }

    public void visit(ExpLinkNode node) {
        this.rstWriter.markup("`");
        this.visitChildren((SuperNode)node);
        this.rstWriter.markup(" <" + node.url + ">`_");
        this.unsupported((AbstractNode)node);
    }

    public void visit(HeaderNode node) {
        this.visitChildren((SuperNode)node);
        int level = node.getLevel();
        String delimiter = this.headers.length >= level ? this.headers[level - 1] : this.headers[0];
        this.rstWriter.newLine();
        this.rstWriter.markup(StringUtils.repeat((String)delimiter, (int)this.rstWriter.getLastLineLength()));
        this.rstWriter.newLine();
        this.rstWriter.newLine();
    }

    public void visit(HtmlBlockNode node) {
        this.rstWriter.markup(".. raw:: html");
        this.rstWriter.newLine();
        this.rstWriter.newLine();
        this.rstWriter.indent();
        this.rstWriter.markup(node.getText());
        this.rstWriter.outdent();
        this.rstWriter.newLine();
        this.rstWriter.markup("..");
        this.rstWriter.newLine();
        this.rstWriter.newLine();
        this.rstWriter.newLine();
    }

    public void visit(InlineHtmlNode node) {
        this.rstWriter.enableRawInlineHtml();
        this.rstWriter.markup(" :raw-html:`" + node.getText() + "` ");
    }

    public void visit(ListItemNode node) {
        this.rstWriter.markup(this.listItemMarker + " ");
        this.visitChildren((SuperNode)node);
        this.rstWriter.newLine();
    }

    public void visit(MailLinkNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(OrderedListNode node) {
        this.listItemMarker = "#.";
        this.visitChildren((SuperNode)node);
        this.rstWriter.newLine();
    }

    public void visit(ParaNode node) {
        this.visitChildren((SuperNode)node);
        this.rstWriter.newLine();
        this.rstWriter.newLine();
    }

    public void visit(QuotedNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(ReferenceNode node) {
        this.unsupported((AbstractNode)node);
        this.visitChildren((SuperNode)node);
    }

    public void visit(RefImageNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(RefLinkNode node) {
        this.unsupported((AbstractNode)node);
        this.visitChildren((SuperNode)node);
    }

    public void visit(RootNode node) {
        this.visitChildren((SuperNode)node);
    }

    public void visit(SimpleNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(SpecialTextNode node) {
        this.rstWriter.text(node.getText());
    }

    public void visit(StrikeNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(StrongEmphSuperNode node) {
        String delimiter = node.isStrong() ? "**" : "*";
        this.rstWriter.markup(delimiter);
        this.visitChildren((SuperNode)node);
        this.rstWriter.markup(delimiter);
    }

    public void visit(TableBodyNode node) {
        this.table.setNextRowType(RowType.BODY);
        this.visitChildren((SuperNode)node);
    }

    public void visit(TableCaptionNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(TableCellNode node) {
        Cell cell = this.table.addCell();
        this.setRstWriter("tableCell");
        this.visitChildren((SuperNode)node);
        cell.setRst(this.rstWriter.toString());
        this.rstWriter.clear();
        this.setRstWriter("main");
    }

    public void visit(TableColumnNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(TableHeaderNode node) {
        this.table.setNextRowType(RowType.HEADER);
        this.visitChildren((SuperNode)node);
    }

    public void visit(TableNode node) {
        this.table = new Table();
        this.visitChildren((SuperNode)node);
        this.tableRstWriter.write(this.table);
        this.table = null;
    }

    public void visit(TableRowNode node) {
        this.table.addRow();
        this.visitChildren((SuperNode)node);
    }

    public void visit(VerbatimNode node) {
        if (node.getType() != null && node.getType().length() > 0) {
            this.rstWriter.markup(".. code-block:: " + node.getType());
        } else {
            this.rstWriter.markup("::");
        }
        this.rstWriter.newLine();
        this.rstWriter.newLine();
        this.rstWriter.indent();
        this.rstWriter.markup(node.getText());
        this.rstWriter.outdent();
        this.rstWriter.newLine();
        this.rstWriter.markup("..");
        this.rstWriter.newLine();
        this.rstWriter.newLine();
        this.rstWriter.newLine();
    }

    public void visit(WikiLinkNode node) {
        this.unsupported((AbstractNode)node);
    }

    public void visit(TextNode node) {
        this.rstWriter.text(StringEscapeUtils.unescapeHtml4((String)node.getText()));
    }

    public void visit(SuperNode node) {
        this.visitChildren(node);
    }

    public void visit(Node node) {
    }

    protected void visitChildren(SuperNode node) {
        for (Node child : node.getChildren()) {
            child.accept((Visitor)this);
        }
    }

    protected void setRstWriter(String name) {
        this.rstWriter = this.rstWriters.get(name);
    }

    protected String image(ExpImageNode node) {
        String id = this.hash(node.url + ":" + node.title);
        this.images.put(id, node);
        return id;
    }

    protected void writeImages() {
        for (Map.Entry<String, ExpImageNode> entry : this.images.entrySet()) {
            ExpImageNode image = entry.getValue();
            this.rstWriter.markup(String.format(".. |%s| image:: %s", entry.getKey(), image.url));
            this.rstWriter.newLine();
        }
    }

    protected void unsupported(AbstractNode node) {
        this.unsupported.add(node.toString());
    }

    protected void writeUnsupported() {
        if (this.unsupported.size() < 1) {
            return;
        }
        this.rstWriter.newLine();
        this.rstWriter.markup("..");
        this.rstWriter.newLine();
        this.rstWriter.indent();
        this.rstWriter.markup("Following nodes are not supported yet and were processed only partially during the Markdown to reStructuredText conversion");
        this.rstWriter.newLine();
        for (String node : this.unsupported) {
            this.rstWriter.markup(node);
            this.rstWriter.newLine();
        }
        this.rstWriter.outdent();
    }

    protected String hash(String text) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            md.update(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = md.digest();
        return String.format("%032x", new BigInteger(1, digest));
    }
}

