/*
 * Decompiled with CFR 0.152.
 */
package tools.kaja.pegdown.table;

import java.util.ArrayList;
import java.util.List;
import tools.kaja.pegdown.table.Cell;
import tools.kaja.pegdown.table.Column;
import tools.kaja.pegdown.table.Row;
import tools.kaja.pegdown.table.RowType;

public class Table {
    protected List<Row> rows = new ArrayList<Row>();
    protected List<Column> columns;
    protected Row activeRow;
    protected RowType nextRowType = RowType.BODY;

    public void setNextRowType(RowType type) {
        this.nextRowType = type;
    }

    public void addRow() {
        this.activeRow = new Row(this.nextRowType);
        this.rows.add(this.activeRow);
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public Cell addCell() {
        this.columns = null;
        if (this.activeRow == null) {
            this.addRow();
        }
        return this.activeRow.addCell();
    }

    public List<Column> getColumns() {
        if (this.columns == null) {
            this.loadColumns();
        }
        return this.columns;
    }

    protected void loadColumns() {
        Column column;
        this.columns = new ArrayList<Column>();
        int index = 0;
        while ((column = this.getColumn(index)) != null) {
            this.columns.add(column);
            ++index;
        }
    }

    protected Column getColumn(int index) {
        Column column = new Column();
        for (Row row : this.rows) {
            Cell cell = row.getCell(index);
            if (cell == null) continue;
            column.addCell(cell);
        }
        if (column.size() > 0) {
            return column;
        }
        return null;
    }
}

