/*
 * Decompiled with CFR 0.152.
 */
package tools.kaja.pegdown.table;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import tools.kaja.pegdown.RstWriter;
import tools.kaja.pegdown.table.Cell;
import tools.kaja.pegdown.table.Column;
import tools.kaja.pegdown.table.Row;
import tools.kaja.pegdown.table.RowType;
import tools.kaja.pegdown.table.Table;

public class TableRstWriter {
    protected static final int PADDING = 1;
    protected RstWriter rstWriter;

    public TableRstWriter(RstWriter rstWriter) {
        this.rstWriter = rstWriter;
    }

    public void write(Table table) {
        List<Row> rows = table.getRows();
        if (rows.size() < 1) {
            return;
        }
        List<Column> columns = table.getColumns();
        this.writeRowSeparator(columns, RowType.BODY);
        this.rstWriter.newLine();
        for (Row row : table.getRows()) {
            this.rstWriter.markup("|" + StringUtils.repeat((String)" ", (int)1));
            for (int index = 0; index < columns.size(); ++index) {
                Cell cell = row.getCell(index);
                int cellWidth = 0;
                if (cell != null) {
                    cellWidth = cell.getWidth();
                    this.rstWriter.markup(cell.getRst());
                }
                this.rstWriter.markup(StringUtils.repeat((String)" ", (int)(columns.get(index).getWidth() - cellWidth)));
                this.rstWriter.markup(StringUtils.repeat((String)" ", (int)1) + "|");
                if (index >= columns.size() - 1) continue;
                this.rstWriter.markup(StringUtils.repeat((String)" ", (int)1));
            }
            this.rstWriter.newLine();
            this.writeRowSeparator(columns, row.getType());
            this.rstWriter.newLine();
        }
        this.rstWriter.newLine();
    }

    protected void writeRowSeparator(List<Column> columns, RowType rowType) {
        String underline = rowType == RowType.HEADER ? "=" : "-";
        this.rstWriter.markup("+");
        for (Column column : columns) {
            this.rstWriter.markup(StringUtils.repeat((String)underline, (int)(column.getWidth() + 2)));
            this.rstWriter.markup("+");
        }
    }
}

