/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.modification.internal;

import java.util.HashSet;
import tools.refinery.store.adapter.ModelStoreAdapter;
import tools.refinery.store.dse.modification.DanglingEdges;
import tools.refinery.store.dse.modification.ModificationAdapter;
import tools.refinery.store.map.Cursor;
import tools.refinery.store.model.AnyInterpretation;
import tools.refinery.store.model.Interpretation;
import tools.refinery.store.model.Model;
import tools.refinery.store.representation.AnySymbol;
import tools.refinery.store.representation.Symbol;
import tools.refinery.store.tuple.Tuple;
import tools.refinery.store.tuple.Tuple1;

public class ModificationAdapterImpl
implements ModificationAdapter {
    static final Symbol<Integer> NEXT_ID = Symbol.of((String)"NEXT_ID", (int)0, Integer.class, (Object)0);
    final ModelStoreAdapter storeAdapter;
    final Model model;
    Interpretation<Integer> nodeCountInterpretation;

    ModificationAdapterImpl(ModelStoreAdapter storeAdapter, Model model) {
        this.storeAdapter = storeAdapter;
        this.model = model;
        this.nodeCountInterpretation = model.getInterpretation(NEXT_ID);
    }

    public Model getModel() {
        return this.model;
    }

    public ModelStoreAdapter getStoreAdapter() {
        return this.storeAdapter;
    }

    @Override
    public int getModelSize() {
        return (Integer)this.nodeCountInterpretation.get((Tuple)Tuple.of());
    }

    @Override
    public Tuple1 createObject() {
        int newNodeId = this.getModelSize();
        this.nodeCountInterpretation.put((Tuple)Tuple.of(), (Object)(newNodeId + 1));
        return Tuple.of((int)newNodeId);
    }

    @Override
    public boolean deleteObject(Tuple tuple, DanglingEdges danglingEdges) {
        if (tuple.getSize() != 1) {
            throw new IllegalArgumentException("Tuple size must be 1");
        }
        int objectId = tuple.get(0);
        if (danglingEdges == DanglingEdges.DELETE) {
            this.deleteDanglingEdges(objectId);
        } else if (danglingEdges == DanglingEdges.FAIL && this.hasDanglingEdges(objectId)) {
            return false;
        }
        int modelSize = this.getModelSize();
        if (objectId == modelSize - 1) {
            this.nodeCountInterpretation.put((Tuple)Tuple.of(), (Object)(modelSize - 1));
        }
        return true;
    }

    private void deleteDanglingEdges(int objectId) {
        for (AnySymbol symbol : this.model.getStore().getSymbols()) {
            this.deleteDanglingEdges(objectId, (Symbol)symbol);
        }
    }

    private <T> void deleteDanglingEdges(int objectId, Symbol<T> symbol) {
        Interpretation interpretation = this.model.getInterpretation(symbol);
        HashSet<Tuple> toDelete = new HashSet<Tuple>();
        int arity = symbol.arity();
        for (int i = 0; i < arity; ++i) {
            Cursor cursor = interpretation.getAdjacent(i, objectId);
            while (cursor.move()) {
                toDelete.add((Tuple)cursor.getKey());
            }
        }
        Object defaultValue = symbol.defaultValue();
        for (Tuple tuple : toDelete) {
            interpretation.put(tuple, defaultValue);
        }
    }

    private boolean hasDanglingEdges(int objectId) {
        for (AnySymbol symbol : this.model.getStore().getSymbols()) {
            AnyInterpretation interpretation = this.model.getInterpretation(symbol);
            int arity = symbol.arity();
            for (int i = 0; i < arity; ++i) {
                if (interpretation.getAdjacentSize(i, objectId) <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

