/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.propagation.impl;

import java.util.List;
import tools.refinery.store.dse.propagation.BoundPropagator;
import tools.refinery.store.dse.propagation.PropagationAdapter;
import tools.refinery.store.dse.propagation.PropagationRejectedResult;
import tools.refinery.store.dse.propagation.PropagationRequest;
import tools.refinery.store.dse.propagation.PropagationResult;
import tools.refinery.store.dse.propagation.PropagationStoreAdapter;
import tools.refinery.store.dse.propagation.Propagator;
import tools.refinery.store.dse.propagation.impl.PropagationStoreAdapterImpl;
import tools.refinery.store.model.Model;

class PropagationAdapterImpl
implements PropagationAdapter {
    private final Model model;
    private final PropagationStoreAdapterImpl storeAdapter;
    private final BoundPropagator[] boundPropagators;
    private boolean concretizationInProgress;

    public PropagationAdapterImpl(Model model, PropagationStoreAdapterImpl storeAdapter) {
        this.model = model;
        this.storeAdapter = storeAdapter;
        List<Propagator> propagators = storeAdapter.getPropagators();
        this.boundPropagators = new BoundPropagator[propagators.size()];
        for (int i = 0; i < this.boundPropagators.length; ++i) {
            this.boundPropagators[i] = propagators.get(i).bindToModel(model);
        }
    }

    @Override
    public PropagationResult propagate() {
        return this.propagate(PropagationRequest.PROPAGATE);
    }

    @Override
    public boolean concretizationRequested() {
        for (int i = 0; i < this.boundPropagators.length; ++i) {
            if (!this.boundPropagators[i].concretizationRequested()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean concretizationInProgress() {
        return this.concretizationInProgress;
    }

    @Override
    public PropagationResult concretize() {
        PropagationResult result;
        this.concretizationInProgress = true;
        try {
            result = this.propagate(PropagationRequest.CONCRETIZE);
        }
        finally {
            this.concretizationInProgress = false;
        }
        if (!result.isRejected()) {
            result = result.andThen(this.checkConcretization());
        }
        return result;
    }

    private PropagationResult propagate(PropagationRequest request) {
        PropagationRejectedResult rejectedResult;
        PropagationResult lastResult;
        PropagationResult result = PropagationResult.UNCHANGED;
        do {
            this.model.checkCancelled();
            lastResult = this.propagateOne(request);
            result = result.andThen(lastResult);
        } while (lastResult.isChanged());
        if (lastResult instanceof PropagationRejectedResult && (rejectedResult = (PropagationRejectedResult)lastResult).fatal() && this.storeAdapter.isThrowOnFatalRejection()) {
            rejectedResult.throwIfRejected();
        }
        return result;
    }

    private PropagationResult propagateOne(PropagationRequest request) {
        PropagationResult result = PropagationResult.UNCHANGED;
        for (int i = 0; i < this.boundPropagators.length; ++i) {
            this.model.checkCancelled();
            PropagationResult lastResult = this.propagateUntilFixedPoint(i, request);
            result = result.andThen(lastResult);
            if (result.isRejected()) break;
        }
        return result;
    }

    private PropagationResult propagateUntilFixedPoint(int propagatorIndex, PropagationRequest request) {
        PropagationResult lastResult;
        BoundPropagator propagator = this.boundPropagators[propagatorIndex];
        PropagationResult result = PropagationResult.UNCHANGED;
        do {
            this.model.checkCancelled();
            lastResult = propagator.propagateOne(request);
            result = result.andThen(lastResult);
        } while (lastResult.isChanged());
        return result;
    }

    @Override
    public PropagationResult checkConcretization() {
        PropagationResult result = PropagationResult.UNCHANGED;
        for (int i = 0; i < this.boundPropagators.length; ++i) {
            this.model.checkCancelled();
            BoundPropagator propagator = this.boundPropagators[i];
            PropagationResult lastResult = propagator.checkConcretization();
            result = result.andThen(lastResult);
            if (result.isRejected()) break;
        }
        return result;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public PropagationStoreAdapter getStoreAdapter() {
        return this.storeAdapter;
    }
}

