/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.propagation.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import tools.refinery.store.adapter.AbstractModelAdapterBuilder;
import tools.refinery.store.dse.propagation.PropagationBuilder;
import tools.refinery.store.dse.propagation.PropagationStoreAdapter;
import tools.refinery.store.dse.propagation.Propagator;
import tools.refinery.store.dse.propagation.impl.PropagationStoreAdapterImpl;
import tools.refinery.store.dse.propagation.impl.rule.RuleBasedPropagator;
import tools.refinery.store.dse.transition.Rule;
import tools.refinery.store.model.ModelStore;
import tools.refinery.store.model.ModelStoreBuilder;

public class PropagationBuilderImpl
extends AbstractModelAdapterBuilder<PropagationStoreAdapter>
implements PropagationBuilder {
    private final Set<Rule> propagationRules = new LinkedHashSet<Rule>();
    private final Set<Rule> concretizationRules = new LinkedHashSet<Rule>();
    private final Deque<Propagator> propagators = new ArrayDeque<Propagator>();
    private boolean throwOnFatalRejection = true;

    @Override
    public PropagationBuilder rule(Rule propagationRule) {
        this.checkNotConfigured();
        this.propagationRules.add(propagationRule);
        return this;
    }

    @Override
    public PropagationBuilder concretizationRule(Rule concretizationRule) {
        this.checkNotConfigured();
        this.concretizationRules.add(concretizationRule);
        return this;
    }

    @Override
    public PropagationBuilder propagator(Propagator propagator) {
        this.checkNotConfigured();
        this.propagators.addFirst(propagator);
        return this;
    }

    @Override
    public PropagationBuilder throwOnFatalRejection(boolean throwOnFatalRejection) {
        this.throwOnFatalRejection = throwOnFatalRejection;
        return this;
    }

    protected void doConfigure(ModelStoreBuilder storeBuilder) {
        super.doConfigure(storeBuilder);
        if (!this.propagationRules.isEmpty()) {
            this.propagators.addFirst(new RuleBasedPropagator(List.copyOf(this.propagationRules), List.copyOf(this.concretizationRules)));
        }
        for (Propagator propagator : this.propagators) {
            propagator.configure(storeBuilder);
        }
    }

    protected PropagationStoreAdapter doBuild(ModelStore store) {
        return new PropagationStoreAdapterImpl(store, List.copyOf(this.propagators), this.throwOnFatalRejection);
    }
}

