/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.propagation.impl.rule;

import java.util.HashSet;
import tools.refinery.logic.dnf.Query;
import tools.refinery.store.dse.propagation.PropagationRejectedResult;
import tools.refinery.store.dse.propagation.PropagationResult;
import tools.refinery.store.dse.transition.Rule;
import tools.refinery.store.dse.transition.actions.BoundAction;
import tools.refinery.store.map.Cursor;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelListener;
import tools.refinery.store.query.ModelQueryAdapter;
import tools.refinery.store.query.resultset.ResultSet;
import tools.refinery.store.tuple.Tuple;

class BoundPropagationRule {
    private final Model model;
    private final Rule rule;
    private final ResultSet<Boolean> resultSet;
    private final BoundAction action;
    private final HashSet<Tuple> firedActivations = new HashSet();

    public BoundPropagationRule(Model model, Rule rule) {
        this.model = model;
        this.rule = rule;
        this.resultSet = ((ModelQueryAdapter)model.getAdapter(ModelQueryAdapter.class)).getResultSet((Query)rule.getPrecondition());
        this.action = rule.createAction(model);
        model.addListener(new ModelListener(){

            public void afterRestore() {
                BoundPropagationRule.this.firedActivations.clear();
            }
        });
        this.resultSet.addListener((key, fromValue, toValue) -> {
            if (Boolean.FALSE.equals(toValue)) {
                this.firedActivations.remove(key);
            }
        });
    }

    public boolean canFire() {
        return this.resultSet.size() > 0;
    }

    public PropagationResult fireAll() {
        if (!this.firedActivations.isEmpty()) {
            return new PropagationRejectedResult(this.rule, "Propagation rule '%s' got stuck.".formatted(this.rule.getName()), true);
        }
        if (this.resultSet.size() == 0) {
            return PropagationResult.UNCHANGED;
        }
        Cursor cursor = this.resultSet.getAll();
        while (cursor.move()) {
            this.model.checkCancelled();
            Tuple tuple = (Tuple)cursor.getKey();
            boolean result = this.action.fire(tuple);
            if (!result) {
                return new PropagationRejectedResult(this.rule, "Propagation rule '%s' failed.".formatted(this.rule.getName()));
            }
            this.firedActivations.add(tuple);
        }
        return PropagationResult.PROPAGATED;
    }
}

