/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.propagation.impl.rule;

import java.util.List;
import tools.refinery.store.dse.propagation.BoundPropagator;
import tools.refinery.store.dse.propagation.PropagationResult;
import tools.refinery.store.dse.propagation.impl.rule.BoundPropagationRule;
import tools.refinery.store.dse.transition.Rule;
import tools.refinery.store.model.Model;
import tools.refinery.store.query.ModelQueryAdapter;

public class BoundRuleBasedPropagator
implements BoundPropagator {
    private final ModelQueryAdapter queryEngine;
    private final BoundPropagationRule[] boundPropagationRules;
    private final BoundPropagationRule[] boundConcretizationRules;

    public BoundRuleBasedPropagator(Model model, List<Rule> propagationRules, List<Rule> concretizationRules) {
        this.queryEngine = (ModelQueryAdapter)model.getAdapter(ModelQueryAdapter.class);
        this.boundPropagationRules = BoundRuleBasedPropagator.bindAll(model, propagationRules);
        this.boundConcretizationRules = BoundRuleBasedPropagator.bindAll(model, concretizationRules);
    }

    private static BoundPropagationRule[] bindAll(Model model, List<Rule> rules) {
        BoundPropagationRule[] boundRules = new BoundPropagationRule[rules.size()];
        for (int i = 0; i < boundRules.length; ++i) {
            boundRules[i] = new BoundPropagationRule(model, rules.get(i));
        }
        return boundRules;
    }

    @Override
    public PropagationResult propagateOne() {
        return this.fireAll(this.boundPropagationRules);
    }

    @Override
    public boolean concretizationRequested() {
        this.queryEngine.flushChanges();
        for (int i = 0; i < this.boundConcretizationRules.length; ++i) {
            if (!this.boundConcretizationRules[i].canFire()) continue;
            return true;
        }
        return false;
    }

    @Override
    public PropagationResult concretizeOne() {
        return this.fireAll(this.boundConcretizationRules);
    }

    private PropagationResult fireAll(BoundPropagationRule[] boundRules) {
        PropagationResult lastResult;
        this.queryEngine.flushChanges();
        PropagationResult result = PropagationResult.UNCHANGED;
        for (int i = 0; i < boundRules.length && !(result = result.andThen(lastResult = boundRules[i].fireAll())).isRejected(); ++i) {
        }
        return result;
    }
}

