/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.propagation.impl.rule;

import java.util.List;
import tools.refinery.logic.dnf.AnyQuery;
import tools.refinery.store.dse.propagation.BoundPropagator;
import tools.refinery.store.dse.propagation.Propagator;
import tools.refinery.store.dse.propagation.impl.rule.BoundRuleBasedPropagator;
import tools.refinery.store.dse.transition.Rule;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStoreBuilder;
import tools.refinery.store.query.ModelQueryBuilder;

public class RuleBasedPropagator
implements Propagator {
    private final List<Rule> propagationRules;
    private final List<Rule> concretizationRules;

    public RuleBasedPropagator(List<Rule> propagationRules, List<Rule> concretizationRules) {
        this.propagationRules = propagationRules;
        this.concretizationRules = concretizationRules;
    }

    @Override
    public void configure(ModelStoreBuilder storeBuilder) {
        ModelQueryBuilder queryBuilder = (ModelQueryBuilder)storeBuilder.getAdapter(ModelQueryBuilder.class);
        for (Rule propagationRule : this.propagationRules) {
            queryBuilder.query((AnyQuery)propagationRule.getPrecondition());
        }
        for (Rule concretizationRule : this.concretizationRules) {
            queryBuilder.query((AnyQuery)concretizationRule.getPrecondition());
        }
    }

    @Override
    public BoundPropagator bindToModel(Model model) {
        return new BoundRuleBasedPropagator(model, this.propagationRules, this.concretizationRules);
    }
}

