/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.strategy;

import java.util.Random;
import tools.refinery.store.dse.strategy.BestFirstStoreManager;
import tools.refinery.store.dse.strategy.BestFirstWorker;
import tools.refinery.store.dse.strategy.SubmitResult;
import tools.refinery.store.dse.transition.VersionWithObjectiveValue;
import tools.refinery.store.model.Model;

public class BestFirstExplorer
extends BestFirstWorker {
    final long id;
    Random random;

    public BestFirstExplorer(BestFirstStoreManager storeManager, Model model, long id) {
        super(storeManager, model);
        Random randomGenerator;
        this.id = id;
        this.random = randomGenerator = new Random(id);
    }

    private boolean shouldRun() {
        this.model.checkCancelled();
        return !this.hasEnoughSolution();
    }

    public void explore() {
        VersionWithObjectiveValue lastBest = this.submit().newVersion();
        block0: while (this.shouldRun()) {
            if (lastBest == null && (lastBest = this.random.nextInt(10) == 0 ? this.restoreToRandom(this.random) : this.restoreToBest()) == null) {
                return;
            }
            boolean tryActivation = true;
            while (tryActivation && this.shouldRun()) {
                BestFirstWorker.RandomVisitResult randomVisitResult = this.visitRandomUnvisited(this.random);
                tryActivation = randomVisitResult.shouldRetry();
                SubmitResult newSubmit = randomVisitResult.submitResult();
                if (newSubmit != null) {
                    if (!newSubmit.include()) {
                        this.restoreToLast();
                        continue;
                    }
                    VersionWithObjectiveValue newVisit = newSubmit.newVersion();
                    int compareResult = this.compare(lastBest, newVisit);
                    if (compareResult >= 0) {
                        lastBest = newVisit;
                        continue block0;
                    }
                    lastBest = null;
                    continue block0;
                }
                lastBest = null;
                continue block0;
            }
        }
    }
}

