/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.strategy;

import java.util.function.Consumer;
import tools.refinery.store.dse.strategy.BestFirstExplorer;
import tools.refinery.store.dse.transition.DesignSpaceExplorationStoreAdapter;
import tools.refinery.store.dse.transition.VersionWithObjectiveValue;
import tools.refinery.store.dse.transition.statespace.ActivationStore;
import tools.refinery.store.dse.transition.statespace.EquivalenceClassStore;
import tools.refinery.store.dse.transition.statespace.ObjectivePriorityQueue;
import tools.refinery.store.dse.transition.statespace.SolutionStore;
import tools.refinery.store.dse.transition.statespace.internal.ActivationStoreImpl;
import tools.refinery.store.dse.transition.statespace.internal.FastEquivalenceClassStore;
import tools.refinery.store.dse.transition.statespace.internal.ObjectivePriorityQueueImpl;
import tools.refinery.store.dse.transition.statespace.internal.SolutionStoreImpl;
import tools.refinery.store.map.Version;
import tools.refinery.store.model.ModelStore;
import tools.refinery.store.statecoding.StateCoderStoreAdapter;
import tools.refinery.visualization.statespace.VisualizationStore;
import tools.refinery.visualization.statespace.internal.VisualizationStoreImpl;

public class BestFirstStoreManager {
    ModelStore modelStore;
    ObjectivePriorityQueue objectiveStore;
    ActivationStore activationStore;
    SolutionStore solutionStore;
    EquivalenceClassStore equivalenceClassStore;
    VisualizationStore visualizationStore;

    public BestFirstStoreManager(ModelStore modelStore, int maxNumberOfSolutions) {
        this.modelStore = modelStore;
        DesignSpaceExplorationStoreAdapter storeAdapter = (DesignSpaceExplorationStoreAdapter)modelStore.getAdapter(DesignSpaceExplorationStoreAdapter.class);
        this.objectiveStore = new ObjectivePriorityQueueImpl(storeAdapter.getObjectives());
        Consumer<VersionWithObjectiveValue> whenAllActivationsVisited = x -> this.objectiveStore.remove((VersionWithObjectiveValue)x);
        this.activationStore = new ActivationStoreImpl(storeAdapter.getTransformations().size(), whenAllActivationsVisited);
        this.solutionStore = new SolutionStoreImpl(maxNumberOfSolutions);
        this.equivalenceClassStore = new FastEquivalenceClassStore(this, (StateCoderStoreAdapter)modelStore.getAdapter(StateCoderStoreAdapter.class)){

            @Override
            protected void delegate(VersionWithObjectiveValue version, int[] emptyActivations, boolean accept) {
                throw new UnsupportedOperationException("This equivalence storage is not prepared to resolve symmetries!");
            }
        };
        this.visualizationStore = new VisualizationStoreImpl();
    }

    public ModelStore getModelStore() {
        return this.modelStore;
    }

    ObjectivePriorityQueue getObjectiveStore() {
        return this.objectiveStore;
    }

    ActivationStore getActivationStore() {
        return this.activationStore;
    }

    public SolutionStore getSolutionStore() {
        return this.solutionStore;
    }

    EquivalenceClassStore getEquivalenceClassStore() {
        return this.equivalenceClassStore;
    }

    public VisualizationStore getVisualizationStore() {
        return this.visualizationStore;
    }

    public void startExploration(Version initial) {
        this.startExploration(initial, 1L);
    }

    public void startExploration(Version initial, long randomSeed) {
        BestFirstExplorer bestFirstExplorer = new BestFirstExplorer(this, this.modelStore.createModelForState(initial), randomSeed);
        bestFirstExplorer.explore();
    }
}

