/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.strategy;

import java.util.Random;
import org.jetbrains.annotations.Nullable;
import tools.refinery.store.dse.propagation.PropagationAdapter;
import tools.refinery.store.dse.propagation.PropagationResult;
import tools.refinery.store.dse.strategy.BestFirstStoreManager;
import tools.refinery.store.dse.strategy.SubmitResult;
import tools.refinery.store.dse.transition.DesignSpaceExplorationAdapter;
import tools.refinery.store.dse.transition.ObjectiveValue;
import tools.refinery.store.dse.transition.VersionWithObjectiveValue;
import tools.refinery.store.dse.transition.statespace.ActivationStore;
import tools.refinery.store.dse.transition.statespace.ObjectivePriorityQueue;
import tools.refinery.store.dse.transition.statespace.internal.ActivationStoreWorker;
import tools.refinery.store.map.Version;
import tools.refinery.store.model.Model;
import tools.refinery.store.query.ModelQueryAdapter;
import tools.refinery.store.statecoding.StateCoderAdapter;
import tools.refinery.store.statecoding.StateCoderResult;
import tools.refinery.visualization.statespace.VisualizationStore;

public class BestFirstWorker {
    final BestFirstStoreManager storeManager;
    final Model model;
    final ActivationStoreWorker activationStoreWorker;
    final StateCoderAdapter stateCoderAdapter;
    final DesignSpaceExplorationAdapter explorationAdapter;
    final ModelQueryAdapter queryAdapter;
    @Nullable
    final PropagationAdapter propagationAdapter;
    final VisualizationStore visualizationStore;
    final boolean isVisualizationEnabled;
    protected VersionWithObjectiveValue last = null;

    public BestFirstWorker(BestFirstStoreManager storeManager, Model model) {
        this.storeManager = storeManager;
        this.model = model;
        this.explorationAdapter = (DesignSpaceExplorationAdapter)model.getAdapter(DesignSpaceExplorationAdapter.class);
        this.stateCoderAdapter = (StateCoderAdapter)model.getAdapter(StateCoderAdapter.class);
        this.queryAdapter = (ModelQueryAdapter)model.getAdapter(ModelQueryAdapter.class);
        this.propagationAdapter = model.tryGetAdapter(PropagationAdapter.class).orElse(null);
        this.activationStoreWorker = new ActivationStoreWorker(storeManager.getActivationStore(), this.explorationAdapter.getTransformations());
        this.visualizationStore = storeManager.getVisualizationStore();
        this.isVisualizationEnabled = this.visualizationStore != null;
    }

    public SubmitResult submit() {
        this.checkSynchronized();
        if (this.queryAdapter.hasPendingChanges()) {
            throw new AssertionError((Object)"Pending changes detected before model submission");
        }
        if (this.explorationAdapter.checkExclude()) {
            return new SubmitResult(false, false, null, null);
        }
        StateCoderResult code = this.stateCoderAdapter.calculateStateCode();
        boolean isNew = this.storeManager.getEquivalenceClassStore().submit(code);
        if (isNew) {
            return this.submitNew();
        }
        return new SubmitResult(false, false, null, null);
    }

    private SubmitResult submitNew() {
        VersionWithObjectiveValue versionWithObjectiveValue;
        Version version = this.model.commit();
        ObjectiveValue objectiveValue = this.explorationAdapter.getObjectiveValue();
        this.last = versionWithObjectiveValue = new VersionWithObjectiveValue(version, objectiveValue);
        boolean accepted = this.explorationAdapter.checkAccept();
        this.storeManager.getObjectiveStore().submit(this.last);
        this.storeManager.getActivationStore().markNewAsVisited(this.last, this.activationStoreWorker.calculateEmptyActivationSize());
        if (accepted) {
            boolean bl = accepted = (versionWithObjectiveValue = this.concretizeIfNeeded(versionWithObjectiveValue)) != null;
        }
        if (accepted) {
            this.storeManager.solutionStore.submit(versionWithObjectiveValue);
        }
        if (this.isVisualizationEnabled) {
            this.visualizationStore.addState(version, objectiveValue.toString());
            if (accepted) {
                this.visualizationStore.addSolution(version);
            }
        }
        return new SubmitResult(true, accepted, objectiveValue, this.last);
    }

    private VersionWithObjectiveValue concretizeIfNeeded(VersionWithObjectiveValue originalValue) {
        if (this.propagationAdapter == null) {
            return originalValue;
        }
        Version version = originalValue.version();
        if (this.propagationAdapter.concretizationRequested()) {
            PropagationResult concretizationResult = this.propagationAdapter.concretize();
            if (concretizationResult.isRejected()) {
                this.model.restore(version);
                return null;
            }
            if (concretizationResult.isChanged()) {
                VersionWithObjectiveValue newValue = this.submitConcrete();
                this.model.restore(version);
                return newValue;
            }
        } else if (this.propagationAdapter.checkConcretization().isRejected()) {
            return null;
        }
        return originalValue;
    }

    private VersionWithObjectiveValue submitConcrete() {
        if (this.queryAdapter.hasPendingChanges()) {
            throw new AssertionError((Object)"Pending changes detected before model submission");
        }
        if (this.explorationAdapter.checkExclude()) {
            return null;
        }
        StateCoderResult code = this.stateCoderAdapter.calculateStateCode();
        if (!this.storeManager.getEquivalenceClassStore().submit(code)) {
            return null;
        }
        Version concreteVersion = this.model.commit();
        ObjectiveValue concreteObjectiveValue = this.explorationAdapter.getObjectiveValue();
        VersionWithObjectiveValue versionWithObjectiveValue = new VersionWithObjectiveValue(concreteVersion, concreteObjectiveValue);
        return this.explorationAdapter.checkAccept() ? versionWithObjectiveValue : null;
    }

    public void restoreToLast() {
        if (this.explorationAdapter.getModel().hasUncommittedChanges()) {
            this.explorationAdapter.getModel().restore(this.last.version());
        }
    }

    public VersionWithObjectiveValue restoreToBest() {
        VersionWithObjectiveValue bestVersion;
        this.last = bestVersion = this.storeManager.getObjectiveStore().getBest();
        if (bestVersion != null) {
            this.model.restore(bestVersion.version());
        }
        return this.last;
    }

    public VersionWithObjectiveValue restoreToRandom(Random random) {
        VersionWithObjectiveValue randomVersion;
        ObjectivePriorityQueue objectiveStore = this.storeManager.getObjectiveStore();
        if (objectiveStore.getSize() == 0) {
            return null;
        }
        this.last = randomVersion = objectiveStore.getRandom(random);
        if (randomVersion != null) {
            this.model.restore(randomVersion.version());
        }
        return this.last;
    }

    public int compare(VersionWithObjectiveValue s1, VersionWithObjectiveValue s2) {
        return this.storeManager.getObjectiveStore().getComparator().compare(s1, s2);
    }

    public RandomVisitResult visitRandomUnvisited(Random random) {
        PropagationResult propagationResult;
        this.checkSynchronized();
        if (this.model.hasUncommittedChanges()) {
            throw new IllegalStateException("The model has uncommitted changes!");
        }
        ActivationStore.VisitResult visitResult = this.activationStoreWorker.fireRandomActivation(this.last, random);
        if (!visitResult.successfulVisit()) {
            return new RandomVisitResult(null, visitResult.mayHaveMore());
        }
        if (this.propagationAdapter != null && (propagationResult = this.propagationAdapter.propagate()).isRejected()) {
            return new RandomVisitResult(null, visitResult.mayHaveMore());
        }
        this.queryAdapter.flushChanges();
        Version oldVersion = null;
        if (this.isVisualizationEnabled) {
            oldVersion = this.last.version();
        }
        SubmitResult submitResult = this.submit();
        if (this.isVisualizationEnabled && submitResult.newVersion() != null) {
            Version newVersion = submitResult.newVersion().version();
            this.visualizationStore.addTransition(oldVersion, newVersion, "fire: " + visitResult.transformation() + ", " + visitResult.activation());
        }
        return new RandomVisitResult(submitResult, visitResult.mayHaveMore());
    }

    public boolean hasEnoughSolution() {
        return this.storeManager.solutionStore.hasEnoughSolution();
    }

    private void checkSynchronized() {
        if (this.last != null && !this.last.version().equals((Object)this.model.getState())) {
            throw new AssertionError((Object)"Worker is not synchronized with model state");
        }
    }

    public record RandomVisitResult(SubmitResult submitResult, boolean shouldRetry) {
    }
}

