/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition;

import tools.refinery.logic.dnf.RelationalQuery;
import tools.refinery.store.dse.transition.RuleBuilder;
import tools.refinery.store.dse.transition.actions.Action;
import tools.refinery.store.dse.transition.actions.BoundAction;
import tools.refinery.store.dse.transition.callback.RuleCallback0;
import tools.refinery.store.dse.transition.callback.RuleCallback1;
import tools.refinery.store.dse.transition.callback.RuleCallback2;
import tools.refinery.store.dse.transition.callback.RuleCallback3;
import tools.refinery.store.dse.transition.callback.RuleCallback4;
import tools.refinery.store.model.Model;

public class Rule {
    private final String name;
    private final RelationalQuery precondition;
    private final Action action;

    public Rule(String name, RelationalQuery precondition, Action action) {
        if (precondition.arity() != action.getArity()) {
            throw new IllegalArgumentException("Expected an action clause with %d parameters, got %d instead".formatted(precondition.arity(), action.getArity()));
        }
        this.name = name;
        this.precondition = precondition;
        this.action = action;
    }

    public String getName() {
        return this.name;
    }

    public RelationalQuery getPrecondition() {
        return this.precondition;
    }

    public BoundAction createAction(Model model) {
        return this.action.bindToModel(model);
    }

    public static RuleBuilder builder(String name) {
        return new RuleBuilder(name);
    }

    public static RuleBuilder builder() {
        return Rule.builder(null);
    }

    public static Rule of(String name, RuleCallback0 callback) {
        RuleBuilder builder = Rule.builder(name);
        callback.accept(builder);
        return builder.build();
    }

    public static Rule of(RuleCallback0 callback) {
        return Rule.of(null, callback);
    }

    public static Rule of(String name, RuleCallback1 callback) {
        RuleBuilder builder = Rule.builder(name);
        callback.accept(builder, builder.parameter("p1"));
        return builder.build();
    }

    public static Rule of(RuleCallback1 callback) {
        return Rule.of(null, callback);
    }

    public static Rule of(String name, RuleCallback2 callback) {
        RuleBuilder builder = Rule.builder(name);
        callback.accept(builder, builder.parameter("p1"), builder.parameter("p2"));
        return builder.build();
    }

    public static Rule of(RuleCallback2 callback) {
        return Rule.of(null, callback);
    }

    public static Rule of(String name, RuleCallback3 callback) {
        RuleBuilder builder = Rule.builder(name);
        callback.accept(builder, builder.parameter("p1"), builder.parameter("p2"), builder.parameter("p3"));
        return builder.build();
    }

    public static Rule of(RuleCallback3 callback) {
        return Rule.of(null, callback);
    }

    public static Rule of(String name, RuleCallback4 callback) {
        RuleBuilder builder = Rule.builder(name);
        callback.accept(builder, builder.parameter("p1"), builder.parameter("p2"), builder.parameter("p3"), builder.parameter("p4"));
        return builder.build();
    }

    public static Rule of(RuleCallback4 callback) {
        return Rule.of(null, callback);
    }
}

