/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition;

import java.util.List;
import tools.refinery.logic.dnf.AbstractQueryBuilder;
import tools.refinery.logic.dnf.Dnf;
import tools.refinery.logic.dnf.RelationalQuery;
import tools.refinery.logic.term.Variable;
import tools.refinery.store.dse.transition.Rule;
import tools.refinery.store.dse.transition.actions.Action;
import tools.refinery.store.dse.transition.actions.ActionLiteral;
import tools.refinery.store.dse.transition.callback.ActionCallback0;
import tools.refinery.store.dse.transition.callback.ActionCallback1;
import tools.refinery.store.dse.transition.callback.ActionCallback2;
import tools.refinery.store.dse.transition.callback.ActionCallback3;
import tools.refinery.store.dse.transition.callback.ActionCallback4;

public class RuleBuilder
extends AbstractQueryBuilder<RuleBuilder> {
    private final String name;
    private List<ActionLiteral> action;

    RuleBuilder(String name) {
        super(Dnf.builder((String)(name == null ? null : name + "#precondition")));
        this.name = name;
    }

    protected RuleBuilder self() {
        return this;
    }

    public RuleBuilder action(ActionLiteral ... literals) {
        return this.action(List.of(literals));
    }

    public RuleBuilder action(List<? extends ActionLiteral> literals) {
        if (this.action != null) {
            throw new IllegalStateException("Actions have already been set");
        }
        this.action = List.copyOf(literals);
        return this;
    }

    public RuleBuilder action(Action action) {
        return this.action(action.getActionLiterals());
    }

    public RuleBuilder action(ActionCallback0 callback) {
        return this.action(callback.toLiterals());
    }

    public RuleBuilder action(ActionCallback1 callback) {
        return this.action(callback.toLiterals(Variable.of((String)"v1")));
    }

    public RuleBuilder action(ActionCallback2 callback) {
        return this.action(callback.toLiterals(Variable.of((String)"v1"), Variable.of((String)"v2")));
    }

    public RuleBuilder action(ActionCallback3 callback) {
        return this.action(callback.toLiterals(Variable.of((String)"v1"), Variable.of((String)"v2"), Variable.of((String)"v3")));
    }

    public RuleBuilder action(ActionCallback4 callback) {
        return this.action(callback.toLiterals(Variable.of((String)"v1"), Variable.of((String)"v2"), Variable.of((String)"v3"), Variable.of((String)"v4")));
    }

    public Rule build() {
        if (this.action == null) {
            throw new IllegalStateException("Rule '%s' has no action".formatted(this.name));
        }
        RelationalQuery precondition = this.dnfBuilder.build().asRelation();
        return new Rule(this.name, precondition, Action.ofPrecondition(precondition, this.action));
    }
}

