/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition;

import tools.refinery.logic.dnf.Query;
import tools.refinery.logic.dnf.RelationalQuery;
import tools.refinery.store.dse.transition.Rule;
import tools.refinery.store.dse.transition.actions.BoundAction;
import tools.refinery.store.model.Model;
import tools.refinery.store.query.ModelQueryAdapter;
import tools.refinery.store.query.resultset.OrderedResultSet;
import tools.refinery.store.query.resultset.ResultSet;
import tools.refinery.store.tuple.Tuple;

public class Transformation {
    private final Rule definition;
    private final OrderedResultSet<Boolean> activations;
    private final BoundAction action;

    public Transformation(Model model, Rule definition) {
        this.definition = definition;
        RelationalQuery precondition = definition.getPrecondition();
        ModelQueryAdapter queryEngine = (ModelQueryAdapter)model.getAdapter(ModelQueryAdapter.class);
        this.activations = new OrderedResultSet(queryEngine.getResultSet((Query)precondition));
        this.action = definition.createAction(model);
    }

    public Rule getDefinition() {
        return this.definition;
    }

    public ResultSet<Boolean> getAllActivationsAsResultSet() {
        return this.activations;
    }

    public Tuple getActivation(int index) {
        return this.activations.getKey(index);
    }

    public boolean fireActivation(Tuple activation) {
        return this.action.fire(activation);
    }
}

