/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.actions;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.collections.api.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.jetbrains.annotations.Nullable;
import tools.refinery.logic.dnf.RelationalQuery;
import tools.refinery.logic.dnf.SymbolicParameter;
import tools.refinery.logic.term.NodeVariable;
import tools.refinery.store.dse.transition.actions.ActionLiteral;
import tools.refinery.store.dse.transition.actions.BoundAction;
import tools.refinery.store.model.Model;

public class Action {
    private final List<NodeVariable> parameters;
    private final Set<NodeVariable> localVariables;
    private final List<ActionLiteral> actionLiterals;
    private final int[] @Nullable [] inputAllocations;
    private final int[] @Nullable [] outputAllocations;

    public Action(List<NodeVariable> parameters, List<? extends ActionLiteral> actionLiterals) {
        this.parameters = List.copyOf(parameters);
        this.actionLiterals = List.copyOf(actionLiterals);
        MutableObjectIntMap allocation = ObjectIntMaps.mutable.empty();
        int arity = parameters.size();
        for (int i = 0; i < arity; ++i) {
            allocation.put((Object)parameters.get(i), i);
        }
        LinkedHashSet<NodeVariable> mutableLocalVariables = new LinkedHashSet<NodeVariable>();
        int size = actionLiterals.size();
        this.inputAllocations = new int[size][];
        this.outputAllocations = new int[size][];
        for (int i = 0; i < size; ++i) {
            this.computeInputAllocation(i, parameters, (MutableObjectIntMap<NodeVariable>)allocation);
            this.computeOutputAllocation(i, mutableLocalVariables, (MutableObjectIntMap<NodeVariable>)allocation);
        }
        this.localVariables = Collections.unmodifiableSet(mutableLocalVariables);
    }

    private void computeInputAllocation(int actionIndex, List<NodeVariable> parameters, MutableObjectIntMap<NodeVariable> allocation) {
        ActionLiteral actionLiteral = this.actionLiterals.get(actionIndex);
        List<NodeVariable> inputVariables = actionLiteral.getInputVariables();
        if (inputVariables.equals(parameters)) {
            return;
        }
        int[] inputs = new int[inputVariables.size()];
        for (int i = 0; i < inputs.length; ++i) {
            NodeVariable variable = inputVariables.get(i);
            if (!allocation.containsKey((Object)variable)) {
                throw new IllegalArgumentException("Unbound input variable %s of action literal %s".formatted(variable, actionLiteral));
            }
            inputs[i] = allocation.get((Object)variable);
        }
        this.inputAllocations[actionIndex] = inputs;
    }

    private void computeOutputAllocation(int actionIndex, Set<NodeVariable> mutableLocalVariable, MutableObjectIntMap<NodeVariable> allocation) {
        ActionLiteral actionLiteral = this.actionLiterals.get(actionIndex);
        List<NodeVariable> outputVariables = actionLiteral.getOutputVariables();
        int size = outputVariables.size();
        if (size == 0) {
            return;
        }
        if (size >= 2 && new HashSet<NodeVariable>(outputVariables).size() != size) {
            throw new IllegalArgumentException("Action literal %s has duplicate output variables %s".formatted(actionLiteral, outputVariables));
        }
        int arity = this.parameters.size();
        int[] outputs = new int[size];
        for (int i = 0; i < size; ++i) {
            NodeVariable variable = outputVariables.get(i);
            if (allocation.containsKey((Object)variable)) {
                throw new IllegalArgumentException("Output variable %s of action literal %s was already assigned".formatted(variable, actionLiteral));
            }
            int variableId = mutableLocalVariable.size();
            allocation.put((Object)variable, arity + variableId);
            outputs[i] = variableId;
            mutableLocalVariable.add(variable);
        }
        this.outputAllocations[actionIndex] = outputs;
    }

    public List<NodeVariable> getParameters() {
        return this.parameters;
    }

    public int getArity() {
        return this.parameters.size();
    }

    public Set<NodeVariable> getLocalVariables() {
        return this.localVariables;
    }

    public List<ActionLiteral> getActionLiterals() {
        return this.actionLiterals;
    }

    int @Nullable [] getInputAllocation(int actionIndex) {
        return this.inputAllocations[actionIndex];
    }

    int @Nullable [] getOutputAllocation(int actionIndex) {
        return this.outputAllocations[actionIndex];
    }

    public BoundAction bindToModel(Model model) {
        return new BoundAction(this, model);
    }

    public static Action ofSymbolicParameters(List<SymbolicParameter> symbolicParameters, List<? extends ActionLiteral> actionLiterals) {
        List<NodeVariable> nodeVariables = symbolicParameters.stream().map(symbolicParameter -> symbolicParameter.getVariable().asNodeVariable()).toList();
        return new Action(nodeVariables, actionLiterals);
    }

    public static Action ofPrecondition(RelationalQuery precondition, List<? extends ActionLiteral> actionLiterals) {
        return Action.ofSymbolicParameters(precondition.getDnf().getSymbolicParameters(), actionLiterals);
    }
}

