/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.actions;

import java.util.List;
import java.util.Objects;
import tools.refinery.logic.term.NodeVariable;
import tools.refinery.store.dse.transition.actions.ConstantActionLiteral;
import tools.refinery.store.dse.transition.actions.PutActionLiteral;
import tools.refinery.store.representation.Symbol;

public final class ActionLiterals {
    private ActionLiterals() {
        throw new IllegalArgumentException("This is a static utility class and should not be instantiated directly");
    }

    public static ConstantActionLiteral constant(NodeVariable variable, int nodeId) {
        return new ConstantActionLiteral(variable, nodeId);
    }

    public static <T> PutActionLiteral<T> put(Symbol<T> symbol, T value, NodeVariable ... parameters) {
        return new PutActionLiteral<T>(symbol, value, List.of(parameters));
    }

    public static PutActionLiteral<Boolean> add(Symbol<Boolean> symbol, NodeVariable ... parameters) {
        if (!Objects.equals(symbol.defaultValue(), false)) {
            throw new IllegalArgumentException("Use put to add a value to symbols other than two-valued logic");
        }
        return ActionLiterals.put(symbol, true, parameters);
    }

    public static <T> PutActionLiteral<T> remove(Symbol<T> symbol, NodeVariable ... parameters) {
        return ActionLiterals.put(symbol, symbol.defaultValue(), parameters);
    }
}

