/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.actions;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import tools.refinery.store.dse.transition.actions.Action;
import tools.refinery.store.dse.transition.actions.ActionLiteral;
import tools.refinery.store.dse.transition.actions.BoundActionLiteral;
import tools.refinery.store.model.Model;
import tools.refinery.store.tuple.Tuple;

public class BoundAction {
    private final Action action;
    private final Model model;
    private BoundActionLiteral @Nullable [] boundLiterals;
    private Tuple activation;
    private final int[] localVariables;

    BoundAction(Action action, Model model) {
        this.action = action;
        this.model = model;
        this.localVariables = new int[action.getLocalVariables().size()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fire(Tuple activation) {
        this.model.checkCancelled();
        if (this.activation != null) {
            throw new IllegalStateException("Reentrant firing is not allowed");
        }
        this.activation = activation;
        if (this.boundLiterals == null) {
            this.boundLiterals = this.bindLiterals();
        }
        try {
            int size = this.boundLiterals.length;
            for (int i = 0; i < size; ++i) {
                BoundActionLiteral boundLiteral = this.boundLiterals[i];
                int[] inputAllocation = this.action.getInputAllocation(i);
                Tuple input = this.getInputTuple(inputAllocation);
                Tuple output = boundLiteral.fire(input);
                if (output == null) {
                    boolean bl = false;
                    return bl;
                }
                int[] outputAllocation = this.action.getOutputAllocation(i);
                this.setOutputTuple(outputAllocation, output);
            }
        }
        finally {
            this.activation = null;
        }
        return true;
    }

    private BoundActionLiteral[] bindLiterals() {
        List<ActionLiteral> actionLiterals = this.action.getActionLiterals();
        int size = actionLiterals.size();
        BoundActionLiteral[] boundLiteralsArray = new BoundActionLiteral[size];
        for (int i = 0; i < size; ++i) {
            boundLiteralsArray[i] = actionLiterals.get(i).bindToModel(this.model);
        }
        return boundLiteralsArray;
    }

    private Tuple getInputTuple(int @Nullable [] inputAllocation) {
        if (inputAllocation == null) {
            return this.activation;
        }
        return switch (inputAllocation.length) {
            case 0 -> Tuple.of();
            case 1 -> Tuple.of((int)this.getInput(inputAllocation[0]));
            case 2 -> Tuple.of((int)this.getInput(inputAllocation[0]), (int)this.getInput(inputAllocation[1]));
            case 3 -> Tuple.of((int)this.getInput(inputAllocation[0]), (int)this.getInput(inputAllocation[1]), (int)this.getInput(inputAllocation[2]));
            case 4 -> Tuple.of((int)this.getInput(inputAllocation[0]), (int)this.getInput(inputAllocation[1]), (int)this.getInput(inputAllocation[2]), (int)this.getInput(inputAllocation[3]));
            default -> {
                int[] elements = new int[inputAllocation.length];
                for (int i = 0; i < inputAllocation.length; ++i) {
                    elements[i] = this.getInput(inputAllocation[i]);
                }
                yield Tuple.of((int[])elements);
            }
        };
    }

    private int getInput(int index) {
        int arity = this.action.getArity();
        return index < arity ? this.activation.get(index) : this.localVariables[index - arity];
    }

    private void setOutputTuple(int @Nullable [] outputAllocation, Tuple output) {
        if (outputAllocation == null || outputAllocation.length == 0) {
            return;
        }
        switch (outputAllocation.length) {
            case 1: {
                this.localVariables[outputAllocation[0]] = output.get(0);
                break;
            }
            case 2: {
                this.localVariables[outputAllocation[0]] = output.get(0);
                this.localVariables[outputAllocation[1]] = output.get(1);
                break;
            }
            case 3: {
                this.localVariables[outputAllocation[0]] = output.get(0);
                this.localVariables[outputAllocation[1]] = output.get(1);
                this.localVariables[outputAllocation[2]] = output.get(2);
                break;
            }
            case 4: {
                this.localVariables[outputAllocation[0]] = output.get(0);
                this.localVariables[outputAllocation[1]] = output.get(1);
                this.localVariables[outputAllocation[2]] = output.get(2);
                this.localVariables[outputAllocation[3]] = output.get(3);
                break;
            }
            default: {
                for (int i = 0; i < outputAllocation.length; ++i) {
                    this.localVariables[outputAllocation[i]] = output.get(i);
                }
            }
        }
    }
}

