/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.actions;

import java.util.List;
import tools.refinery.logic.term.NodeVariable;
import tools.refinery.store.dse.transition.actions.AbstractActionLiteral;
import tools.refinery.store.dse.transition.actions.BoundActionLiteral;
import tools.refinery.store.model.Interpretation;
import tools.refinery.store.model.Model;
import tools.refinery.store.representation.Symbol;
import tools.refinery.store.tuple.Tuple;

public class PutActionLiteral<T>
extends AbstractActionLiteral {
    private final Symbol<T> symbol;
    private final List<NodeVariable> parameters;
    private final T value;

    public PutActionLiteral(Symbol<T> symbol, T value, List<NodeVariable> parameters) {
        if (symbol.arity() != parameters.size()) {
            throw new IllegalArgumentException("Expected %d parameters for symbol %s, got %d instead".formatted(symbol.arity(), symbol, parameters.size()));
        }
        if (value != null && !symbol.valueType().isInstance(value)) {
            throw new IllegalArgumentException("Expected value of type %s for symbol %s, got %s of type %s instead".formatted(symbol.valueType().getName(), symbol, value, value.getClass().getName()));
        }
        this.symbol = symbol;
        this.parameters = List.copyOf(parameters);
        this.value = value;
    }

    public Symbol<T> getSymbol() {
        return this.symbol;
    }

    public List<NodeVariable> getParameters() {
        return this.parameters;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public List<NodeVariable> getInputVariables() {
        return this.getParameters();
    }

    @Override
    public List<NodeVariable> getOutputVariables() {
        return List.of();
    }

    @Override
    public BoundActionLiteral bindToModel(Model model) {
        Interpretation interpretation = model.getInterpretation(this.symbol);
        return tuple -> {
            interpretation.put(tuple, this.value);
            return Tuple.of();
        };
    }
}

