/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.internal;

import java.util.List;
import tools.refinery.store.dse.transition.DesignSpaceExplorationAdapter;
import tools.refinery.store.dse.transition.DesignSpaceExplorationStoreAdapter;
import tools.refinery.store.dse.transition.ObjectiveValue;
import tools.refinery.store.dse.transition.Transformation;
import tools.refinery.store.dse.transition.objectives.CriterionCalculator;
import tools.refinery.store.dse.transition.objectives.ObjectiveCalculator;
import tools.refinery.store.model.Model;

public class DesignSpaceExplorationAdapterImpl
implements DesignSpaceExplorationAdapter {
    final Model model;
    final DesignSpaceExplorationStoreAdapter designSpaceExplorationStoreAdapter;
    final List<Transformation> transformations;
    final List<CriterionCalculator> accepts;
    final List<CriterionCalculator> excludes;
    final List<ObjectiveCalculator> objectives;

    public DesignSpaceExplorationAdapterImpl(Model model, DesignSpaceExplorationStoreAdapter designSpaceExplorationStoreAdapter, List<Transformation> transformations, List<CriterionCalculator> accepts, List<CriterionCalculator> excludes, List<ObjectiveCalculator> objectives) {
        this.model = model;
        this.designSpaceExplorationStoreAdapter = designSpaceExplorationStoreAdapter;
        this.transformations = transformations;
        this.accepts = accepts;
        this.excludes = excludes;
        this.objectives = objectives;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public DesignSpaceExplorationStoreAdapter getStoreAdapter() {
        return this.designSpaceExplorationStoreAdapter;
    }

    @Override
    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    @Override
    public boolean checkAccept() {
        for (CriterionCalculator accept : this.accepts) {
            this.model.checkCancelled();
            if (accept.isSatisfied()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkExclude() {
        for (CriterionCalculator exclude : this.excludes) {
            this.model.checkCancelled();
            if (!exclude.isSatisfied()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ObjectiveValue getObjectiveValue() {
        this.model.checkCancelled();
        if (this.objectives.size() == 1) {
            return ObjectiveValue.of(this.objectives.get(0).getValue());
        }
        if (this.objectives.size() == 2) {
            return ObjectiveValue.of(this.objectives.get(0).getValue(), this.objectives.get(1).getValue());
        }
        double[] res = new double[this.objectives.size()];
        for (int i = 0; i < this.objectives.size(); ++i) {
            this.model.checkCancelled();
            res[i] = this.objectives.get(i).getValue();
        }
        return ObjectiveValue.of(res);
    }
}

