/*
 * Decompiled with CFR 0.152.
 */
package tools.refinery.store.dse.transition.internal;

import java.util.List;
import tools.refinery.store.dse.transition.DesignSpaceExplorationStoreAdapter;
import tools.refinery.store.dse.transition.Rule;
import tools.refinery.store.dse.transition.Transformation;
import tools.refinery.store.dse.transition.internal.DesignSpaceExplorationAdapterImpl;
import tools.refinery.store.dse.transition.objectives.Criterion;
import tools.refinery.store.dse.transition.objectives.CriterionCalculator;
import tools.refinery.store.dse.transition.objectives.Objective;
import tools.refinery.store.dse.transition.objectives.ObjectiveCalculator;
import tools.refinery.store.model.Model;
import tools.refinery.store.model.ModelStore;

public class DesignSpaceExplorationStoreAdapterImpl
implements DesignSpaceExplorationStoreAdapter {
    protected final ModelStore store;
    protected final List<Rule> ruleDefinitions;
    protected final List<Criterion> accepts;
    protected final List<Criterion> excludes;
    protected final List<Objective> objectives;

    public DesignSpaceExplorationStoreAdapterImpl(ModelStore store, List<Rule> ruleDefinitions, List<Criterion> accepts, List<Criterion> excludes, List<Objective> objectives) {
        this.store = store;
        this.ruleDefinitions = ruleDefinitions;
        this.accepts = accepts;
        this.excludes = excludes;
        this.objectives = objectives;
    }

    public ModelStore getStore() {
        return this.store;
    }

    @Override
    public DesignSpaceExplorationAdapterImpl createModelAdapter(Model model) {
        List<Transformation> t = this.ruleDefinitions.stream().map(x -> new Transformation(model, (Rule)x)).toList();
        List<CriterionCalculator> a = this.accepts.stream().map(x -> x.createCalculator(model)).toList();
        List<CriterionCalculator> e = this.excludes.stream().map(x -> x.createCalculator(model)).toList();
        List<ObjectiveCalculator> o = this.objectives.stream().map(x -> x.createCalculator(model)).toList();
        return new DesignSpaceExplorationAdapterImpl(model, this, t, a, e, o);
    }

    @Override
    public List<Rule> getTransformations() {
        return this.ruleDefinitions;
    }

    @Override
    public List<Criterion> getAccepts() {
        return this.accepts;
    }

    @Override
    public List<Criterion> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<Objective> getObjectives() {
        return this.objectives;
    }
}

